/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline;

import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.Response;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ResponseError;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class TelemetryPipelineResponse {
    private static final String INVALID_INSTRUMENTATION_KEY = "Invalid instrumentation key";
    private final int statusCode;
    private final String body;

    TelemetryPipelineResponse(int statusCode, String body) {
        this.statusCode = statusCode;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public Set<ResponseError> getErrors() {
        try {
            return TelemetryPipelineResponse.parseErrors(this.body);
        }
        catch (IllegalStateException e) {
            return Collections.emptySet();
        }
    }

    public Set<String> getErrorMessages() {
        Set<ResponseError> responseErrors;
        try {
            responseErrors = TelemetryPipelineResponse.parseErrors(this.body);
        }
        catch (IllegalStateException e) {
            return Collections.singleton("Could not parse response");
        }
        return responseErrors.stream().map(ResponseError::getMessage).collect(Collectors.toSet());
    }

    public boolean isInvalidInstrumentationKey() {
        Set<String> errors = this.getErrorMessages();
        return errors != null && errors.contains(INVALID_INSTRUMENTATION_KEY);
    }

    static Set<ResponseError> parseErrors(String body) {
        Set<ResponseError> set;
        block8: {
            JsonReader reader = JsonProviders.createReader((String)body);
            try {
                Response response = Response.fromJson(reader);
                set = response.getErrors().stream().filter(error -> !error.getMessage().equals("Telemetry sampled out.")).collect(Collectors.toSet());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse response body", e);
                }
            }
            reader.close();
        }
        return set;
    }
}

