/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.preaggregatedmetrics;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.MetricTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.preaggregatedmetrics.ExtractorHelper;
import reactor.util.annotation.Nullable;

public final class DependencyExtractor {
    public static final String DEPENDENCIES_DURATION = "dependencies/duration";
    public static final String DEPENDENCY_TYPE = "Dependency.Type";
    public static final String DEPENDENCY_SUCCESS = "Dependency.Success";
    public static final String DEPENDENCY_TARGET = "dependency/target";
    public static final String DEPENDENCY_RESULT_CODE = "dependency/resultCode";

    public static void extract(MetricTelemetryBuilder metricBuilder, @Nullable Long statusCode, boolean success, String type, String target, @Nullable Boolean isSynthetic) {
        ExtractorHelper.extractCommon(metricBuilder, isSynthetic);
        metricBuilder.addProperty("_MS.MetricId", DEPENDENCIES_DURATION);
        if (statusCode != null) {
            metricBuilder.addProperty(DEPENDENCY_RESULT_CODE, String.valueOf(statusCode));
        }
        metricBuilder.addProperty(DEPENDENCY_SUCCESS, success ? "True" : "False");
        metricBuilder.addProperty(DEPENDENCY_TYPE, type);
        metricBuilder.addProperty(DEPENDENCY_TARGET, target);
    }

    private DependencyExtractor() {
    }
}

