/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse;

import com.azure.core.http.HttpPipeline;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseCoordinator;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseCoordinatorInitData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseCoordinatorInitDataBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataCollector;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataFetcher;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataSender;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulsePingSender;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.FilteringConfiguration;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.LiveMetricsRestAPIsForClientSDKs;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.LiveMetricsRestAPIsForClientSDKsBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MonitoringDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.HostName;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.IKeyMasker;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.ThreadPoolUtils;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

public class QuickPulse {
    static final int QP_INVARIANT_VERSION = 5;
    private volatile QuickPulseDataCollector collector;
    private static final ClientLogger LOGGER = new ClientLogger(QuickPulse.class);

    public static QuickPulse create(HttpPipeline httpPipeline, Supplier<URL> endpointUrl, Supplier<String> instrumentationKey, @Nullable String roleName, @Nullable String roleInstance, String sdkVersion) {
        QuickPulse quickPulse = new QuickPulse();
        ExecutorService executor = Executors.newSingleThreadExecutor(ThreadPoolUtils.createDaemonThreadFactory(QuickPulse.class));
        executor.execute(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            quickPulse.initialize(httpPipeline, endpointUrl, instrumentationKey, roleName, roleInstance, sdkVersion);
        });
        if (executor.isTerminated()) {
            throw new AssertionError();
        }
        return quickPulse;
    }

    public boolean isEnabled() {
        return this.collector.isEnabled();
    }

    public void add(TelemetryItem telemetryItem) {
        if (this.collector != null) {
            this.collector.add(telemetryItem);
        }
    }

    private void initialize(HttpPipeline httpPipeline, Supplier<URL> endpointUrl, Supplier<String> instrumentationKey, @Nullable String roleName, @Nullable String roleInstance, String sdkVersion) {
        if (LOGGER.canLogAtLevel(LogLevel.VERBOSE)) {
            LOGGER.verbose("Initializing QuickPulse with instrumentation key: {} , URL {}, rolename {}, role instance {}, sdk version {}", new Object[]{IKeyMasker.mask(instrumentationKey.get()), endpointUrl.get().toString(), roleName, roleInstance, sdkVersion});
        }
        String quickPulseId = UUID.randomUUID().toString().replace("-", "");
        ArrayBlockingQueue<MonitoringDataPoint> sendQueue = new ArrayBlockingQueue<MonitoringDataPoint>(256, true);
        LiveMetricsRestAPIsForClientSDKsBuilder builder = new LiveMetricsRestAPIsForClientSDKsBuilder();
        LiveMetricsRestAPIsForClientSDKs liveMetricsRestAPIsForClientSDKs = builder.pipeline(httpPipeline).buildClient();
        String instanceName = roleInstance;
        String machineName = HostName.get();
        if (Strings.isNullOrEmpty(instanceName)) {
            instanceName = machineName;
        }
        if (Strings.isNullOrEmpty(instanceName)) {
            instanceName = "Unknown host";
        }
        FilteringConfiguration configuration = new FilteringConfiguration();
        AtomicReference<FilteringConfiguration> atomicConfig = new AtomicReference<FilteringConfiguration>(configuration);
        QuickPulseDataCollector collector = new QuickPulseDataCollector(atomicConfig);
        QuickPulsePingSender quickPulsePingSender = new QuickPulsePingSender(liveMetricsRestAPIsForClientSDKs, endpointUrl, instrumentationKey, roleName, instanceName, machineName, quickPulseId, sdkVersion, atomicConfig);
        QuickPulseDataSender quickPulseDataSender = new QuickPulseDataSender(liveMetricsRestAPIsForClientSDKs, sendQueue, endpointUrl, instrumentationKey, atomicConfig);
        QuickPulseDataFetcher quickPulseDataFetcher = new QuickPulseDataFetcher(collector, sendQueue, roleName, instanceName, machineName, quickPulseId, sdkVersion);
        QuickPulseCoordinatorInitData coordinatorInitData = new QuickPulseCoordinatorInitDataBuilder().withPingSender(quickPulsePingSender).withDataFetcher(quickPulseDataFetcher).withDataSender(quickPulseDataSender).withCollector(collector).build();
        QuickPulseCoordinator coordinator = new QuickPulseCoordinator(coordinatorInitData);
        Thread senderThread = new Thread((Runnable)quickPulseDataSender, QuickPulseDataSender.class.getSimpleName());
        senderThread.setDaemon(true);
        senderThread.start();
        Thread thread = new Thread((Runnable)coordinator, QuickPulseCoordinator.class.getSimpleName());
        thread.setDaemon(true);
        thread.start();
        collector.enable(instrumentationKey);
        this.collector = collector;
    }
}

