/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseCoordinatorInitData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataCollector;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataFetcher;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataSender;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulsePingSender;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseStatus;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.IsSubscribedHeaders;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;
import reactor.util.annotation.Nullable;

final class QuickPulseCoordinator
implements Runnable {
    private static final ClientLogger logger = new ClientLogger(QuickPulseCoordinator.class);
    @Nullable
    private String qpsServiceRedirectedEndpoint;
    private long qpsServicePollingIntervalHintMillis;
    private volatile boolean stopped = false;
    private volatile boolean pingMode = true;
    private final QuickPulseDataCollector collector;
    private final QuickPulsePingSender pingSender;
    private final QuickPulseDataFetcher dataFetcher;
    private final QuickPulseDataSender dataSender;
    private final long waitBetweenPingsInMillis;
    private final long waitBetweenPostsInMillis;
    private final long waitOnErrorInMillis;

    QuickPulseCoordinator(QuickPulseCoordinatorInitData initData) {
        this.dataSender = initData.dataSender;
        this.pingSender = initData.pingSender;
        this.dataFetcher = initData.dataFetcher;
        this.collector = initData.collector;
        this.waitBetweenPingsInMillis = initData.waitBetweenPingsInMillis;
        this.waitBetweenPostsInMillis = initData.waitBetweenPostsInMillis;
        this.waitOnErrorInMillis = initData.waitOnErrorInMillis;
        this.qpsServiceRedirectedEndpoint = null;
        this.qpsServicePollingIntervalHintMillis = -1L;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped) {
                long sleepInMillis = this.pingMode ? this.ping() : this.sendData();
                Thread.sleep(sleepInMillis);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("QuickPulseCoordinator was interrupted", new Object[]{e});
        }
        catch (Throwable t) {
            logger.error("QuickPulseCoordinator failed", new Object[]{t});
        }
    }

    private long sendData() {
        this.dataFetcher.prepareQuickPulseDataForSend();
        QuickPulseStatus qpStatus = this.dataSender.getQuickPulseStatus();
        this.collector.setQuickPulseStatus(qpStatus);
        switch (qpStatus) {
            case ERROR: {
                this.pingMode = true;
                long errorDelayInNs = TimeUnit.SECONDS.toNanos(40L);
                this.pingSender.resetLastValidRequestTimeNs(this.dataSender.getLastValidPostRequestTimeNs() - errorDelayInNs);
                logger.verbose("Switching to fallback mode.");
                return this.waitOnErrorInMillis;
            }
            case QP_IS_OFF: {
                this.pingMode = true;
                this.pingSender.resetLastValidRequestTimeNs(this.dataSender.getLastValidPostRequestTimeNs());
                logger.verbose("Switching to ping mode.");
                return this.qpsServicePollingIntervalHintMillis > 0L ? this.qpsServicePollingIntervalHintMillis : this.waitBetweenPingsInMillis;
            }
            case QP_IS_ON: {
                return this.waitBetweenPostsInMillis;
            }
        }
        try (MDC.MDCCloseable ignored = AzureMonitorMsgId.QUICK_PULSE_SEND_ERROR.makeActive();){
            logger.error("Critical error while sending QP data: unknown status, aborting");
        }
        this.collector.disable();
        this.stopped = true;
        return 0L;
    }

    private long ping() {
        IsSubscribedHeaders pingResult = this.pingSender.ping(this.qpsServiceRedirectedEndpoint);
        QuickPulseStatus qpStatus = this.handleReceivedPingHeaders(pingResult);
        this.collector.setQuickPulseStatus(qpStatus);
        switch (qpStatus) {
            case ERROR: {
                logger.verbose("In fallback mode");
                return this.waitOnErrorInMillis;
            }
            case QP_IS_ON: {
                this.pingMode = false;
                logger.verbose("Switching to post mode");
                long lastValidRequestTransmission = this.pingSender.getLastValidPingTransmissionNs();
                this.dataSender.resetLastValidRequestTimeNs(lastValidRequestTransmission);
                this.dataSender.startSending();
                return this.waitBetweenPostsInMillis;
            }
            case QP_IS_OFF: {
                return this.qpsServicePollingIntervalHintMillis > 0L ? this.qpsServicePollingIntervalHintMillis : this.waitBetweenPingsInMillis;
            }
        }
        try (MDC.MDCCloseable ignored = AzureMonitorMsgId.QUICK_PULSE_PING_ERROR.makeActive();){
            logger.error("Critical error while ping QP: unknown status, aborting");
        }
        this.collector.disable();
        this.stopped = true;
        return 0L;
    }

    private QuickPulseStatus handleReceivedPingHeaders(IsSubscribedHeaders pingHeaders) {
        long newPollingInterval;
        String pollingIntervalHeader;
        String redirectLink = pingHeaders.getXMsQpsServiceEndpointRedirectV2();
        if (!Strings.isNullOrEmpty(redirectLink)) {
            try {
                URL redirectUrl = new URL(redirectLink);
                this.qpsServiceRedirectedEndpoint = redirectUrl.getProtocol() + "://" + redirectUrl.getHost() + "/";
                logger.verbose("Handling ping header to redirect to {}", new Object[]{this.qpsServiceRedirectedEndpoint});
                this.dataSender.setRedirectEndpointPrefix(this.qpsServiceRedirectedEndpoint);
            }
            catch (MalformedURLException e) {
                logger.error("The service returned a malformed URL in the redirect header: {}. Exception message: {}", new Object[]{redirectLink, e.getMessage()});
            }
        }
        if (!Strings.isNullOrEmpty(pollingIntervalHeader = pingHeaders.getXMsQpsServicePollingIntervalHint()) && (newPollingInterval = Long.getLong(pingHeaders.getXMsQpsServicePollingIntervalHint()).longValue()) > 0L) {
            this.qpsServicePollingIntervalHintMillis = newPollingInterval;
        }
        return this.getQuickPulseStatusFromHeader(pingHeaders.getXMsQpsSubscribed());
    }

    private QuickPulseStatus getQuickPulseStatusFromHeader(String headerValue) {
        if (Strings.isNullOrEmpty(headerValue)) {
            return QuickPulseStatus.ERROR;
        }
        if ("true".equalsIgnoreCase(headerValue)) {
            return QuickPulseStatus.QP_IS_ON;
        }
        return QuickPulseStatus.QP_IS_OFF;
    }

    void stop() {
        this.stopped = true;
    }
}

