/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseDataCollector;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MetricPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MonitoringDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.MDC;

class QuickPulseDataFetcher {
    private static final ClientLogger logger = new ClientLogger(QuickPulseDataFetcher.class);
    private final QuickPulseDataCollector collector;
    private final ArrayBlockingQueue<MonitoringDataPoint> sendQueue;
    private final String roleName;
    private final String instanceName;
    private final String machineName;
    private final String quickPulseId;
    private final String sdkVersion;

    public QuickPulseDataFetcher(QuickPulseDataCollector collector, ArrayBlockingQueue<MonitoringDataPoint> sendQueue, String roleName, String instanceName, String machineName, String quickPulseId, String sdkVersion) {
        this.collector = collector;
        this.sendQueue = sendQueue;
        this.roleName = roleName;
        this.instanceName = instanceName;
        this.machineName = machineName;
        this.quickPulseId = quickPulseId;
        this.sdkVersion = sdkVersion;
    }

    String getCurrentSdkVersion() {
        return "unknown";
    }

    public void prepareQuickPulseDataForSend() {
        block13: {
            try {
                QuickPulseDataCollector.FinalCounters counters = this.collector.getAndRestart();
                if (counters == null) {
                    return;
                }
                MonitoringDataPoint point = this.buildMonitoringDataPoint(counters);
                if (!this.sendQueue.offer(point)) {
                    logger.verbose("Quick Pulse send queue is full");
                }
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                try (MDC.MDCCloseable ignored = AzureMonitorMsgId.QUICK_PULSE_SEND_ERROR.makeActive();){
                    logger.error("Quick Pulse failed to prepare data for send", new Object[]{e});
                }
                catch (Throwable t2) {
                    if (!(t2 instanceof Error)) break block13;
                    throw (Error)t2;
                }
            }
        }
    }

    private MonitoringDataPoint buildMonitoringDataPoint(QuickPulseDataCollector.FinalCounters counters) {
        MonitoringDataPoint point = new MonitoringDataPoint();
        point.setDocuments(counters.documentList);
        point.setInstance(this.instanceName);
        point.setInvariantVersion(5);
        point.setMachineName(this.machineName);
        point.setRoleName(this.roleName);
        point.setStreamId(this.quickPulseId);
        point.setVersion(this.sdkVersion);
        point.setTimestamp(OffsetDateTime.now());
        point.setMetrics(QuickPulseDataFetcher.addMetricsToMonitoringDataPoint(counters));
        point.setCollectionConfigurationErrors(counters.configErrors);
        return point;
    }

    private static List<MetricPoint> addMetricsToMonitoringDataPoint(QuickPulseDataCollector.FinalCounters counters) {
        ArrayList<MetricPoint> metricsList = new ArrayList<MetricPoint>();
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("\\ApplicationInsights\\Requests/Sec", Double.valueOf(counters.requests));
        if (counters.requests != 0) {
            metrics.put("\\ApplicationInsights\\Request Duration", counters.requestsDuration / (double)counters.requests);
        }
        metrics.put("\\ApplicationInsights\\Requests Failed/Sec", Double.valueOf(counters.unsuccessfulRequests));
        metrics.put("\\ApplicationInsights\\Requests Succeeded/Sec", (double)counters.requests - (double)counters.unsuccessfulRequests);
        metrics.put("\\ApplicationInsights\\Dependency Calls/Sec", Double.valueOf(counters.rdds));
        if (counters.rdds != 0L) {
            metrics.put("\\ApplicationInsights\\Dependency Call Duration", counters.rddsDuration / (double)counters.rdds);
        }
        metrics.put("\\ApplicationInsights\\Dependency Calls Failed/Sec", Double.valueOf(counters.unsuccessfulRdds));
        metrics.put("\\ApplicationInsights\\Dependency Calls Succeeded/Sec", (double)counters.rdds - (double)counters.unsuccessfulRequests);
        metrics.put("\\ApplicationInsights\\Exceptions/Sec", Double.valueOf(counters.exceptions));
        metrics.put("\\Memory\\Committed Bytes", Double.valueOf(counters.processPhysicalMemory));
        metrics.put("\\Process\\Physical Bytes", Double.valueOf(counters.processPhysicalMemory));
        metrics.put("\\Processor(_Total)\\% Processor Time", counters.processNormalizedCpuUsage);
        metrics.put("\\% Process\\Processor Time Normalized", counters.processNormalizedCpuUsage);
        metrics.putAll(counters.projections);
        for (Map.Entry entry : metrics.entrySet()) {
            MetricPoint point = new MetricPoint();
            point.setName((String)entry.getKey());
            point.setValue((Double)entry.getValue());
            point.setWeight(1);
            metricsList.add(point);
        }
        return metricsList;
    }
}

