/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse;

import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseCoordinator;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseStatus;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.FilteringConfiguration;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.LiveMetricsRestAPIsForClientSDKs;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MonitoringDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.PublishHeaders;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class QuickPulseDataSender
implements Runnable {
    private static final ClientLogger logger = new ClientLogger(QuickPulseCoordinator.class);
    private long lastValidRequestTimeNs = 0L;
    private final ArrayBlockingQueue<MonitoringDataPoint> sendQueue;
    private final LiveMetricsRestAPIsForClientSDKs liveMetricsRestAPIsForClientSDKs;
    private final Supplier<URL> endpointUrl;
    private String redirectEndpointPrefix;
    private QuickPulseStatus qpStatus;
    private final Supplier<String> instrumentationKey;
    private static final long TICKS_AT_EPOCH = 621355968000000000L;
    private final AtomicReference<FilteringConfiguration> configuration;

    QuickPulseDataSender(LiveMetricsRestAPIsForClientSDKs liveMetricsRestAPIsForClientSDKs, ArrayBlockingQueue<MonitoringDataPoint> sendQueue, Supplier<URL> endpointUrl, Supplier<String> instrumentationKey, AtomicReference<FilteringConfiguration> configuration) {
        this.sendQueue = sendQueue;
        this.liveMetricsRestAPIsForClientSDKs = liveMetricsRestAPIsForClientSDKs;
        this.endpointUrl = endpointUrl;
        this.qpStatus = QuickPulseStatus.QP_IS_OFF;
        this.instrumentationKey = instrumentationKey;
        this.configuration = configuration;
        logger.verbose("QuickPulseDataSender initialized with endpointUrl: {}, instrumentationKey: {}", new Object[]{endpointUrl.get().toString(), instrumentationKey.get()});
    }

    @Override
    public void run() {
        while (true) {
            MonitoringDataPoint point;
            try {
                point = this.sendQueue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("QuickPulseDataSender was interrupted while waiting for a request", new Object[]{e});
                return;
            }
            if (this.qpStatus != QuickPulseStatus.QP_IS_ON) {
                logger.verbose("QuickPulseDataSender is not sending data because QP is " + (Object)((Object)this.qpStatus));
                continue;
            }
            long sendTime = System.nanoTime();
            String endpointPrefix = Strings.isNullOrEmpty(this.redirectEndpointPrefix) ? this.getQuickPulseEndpoint() : this.redirectEndpointPrefix;
            ArrayList<MonitoringDataPoint> dataPointList = new ArrayList<MonitoringDataPoint>();
            dataPointList.add(point);
            Date currentDate = new Date();
            long transmissionTimeInTicks = currentDate.getTime() * 10000L + 621355968000000000L;
            String etag = this.configuration.get().getETag();
            if (logger.canLogAtLevel(LogLevel.VERBOSE)) {
                logger.verbose("Attempting to send data points to quickpulse with etag {}: {}", new Object[]{etag, this.printListOfMonitoringPoints(dataPointList)});
            }
            try {
                logger.verbose("About to publish to quickpulse with the endpoint prefix: {}", new Object[]{endpointPrefix});
                Response responseMono = (Response)this.liveMetricsRestAPIsForClientSDKs.publishNoCustomHeadersWithResponseAsync(endpointPrefix, this.instrumentationKey.get(), etag, transmissionTimeInTicks, dataPointList).block();
                if (responseMono == null) {
                    throw new AssertionError((Object)"http response mono returned empty");
                }
                PublishHeaders headers = new PublishHeaders(responseMono.getHeaders());
                String isSubscribed = headers.getXMsQpsSubscribed();
                this.qpStatus = Strings.isNullOrEmpty(isSubscribed) || isSubscribed.equalsIgnoreCase("false") ? QuickPulseStatus.QP_IS_OFF : QuickPulseStatus.QP_IS_ON;
                this.lastValidRequestTimeNs = sendTime;
                CollectionConfigurationInfo body = (CollectionConfigurationInfo)responseMono.getValue();
                if (body == null || etag.equals(body.getETag())) continue;
                this.configuration.set(new FilteringConfiguration(body));
                try {
                    logger.verbose("Received a new live metrics filtering configuration from post response: {}", new Object[]{body.toJsonString()});
                }
                catch (IOException e) {
                    logger.verbose(e.getMessage());
                }
                continue;
            }
            catch (RuntimeException e) {
                this.onPostError(sendTime);
                logger.error("QuickPulseDataSender received an error while attempting to send data to quickpulse {}", new Object[]{e.getMessage()});
                continue;
            }
            break;
        }
    }

    void startSending() {
        this.qpStatus = QuickPulseStatus.QP_IS_ON;
    }

    private void onPostError(long sendTime) {
        double timeFromlastValidRequestTimeNs = (double)(sendTime - this.lastValidRequestTimeNs) / 1.0E9;
        if (timeFromlastValidRequestTimeNs >= 20.0) {
            this.qpStatus = QuickPulseStatus.ERROR;
        }
    }

    private String printListOfMonitoringPoints(List<MonitoringDataPoint> points) {
        StringBuilder dataPointsPrint = new StringBuilder("[");
        for (MonitoringDataPoint p : points) {
            try {
                dataPointsPrint.append(p.toJsonString());
                dataPointsPrint.append("\n");
            }
            catch (IOException e) {
                logger.verbose(e.getMessage());
            }
        }
        dataPointsPrint.append("]");
        return dataPointsPrint.toString();
    }

    public void setRedirectEndpointPrefix(String endpointPrefix) {
        this.redirectEndpointPrefix = endpointPrefix;
    }

    private String getQuickPulseEndpoint() {
        return this.endpointUrl.get().toString();
    }

    public QuickPulseStatus getQuickPulseStatus() {
        return this.qpStatus;
    }

    public void resetLastValidRequestTimeNs(long lastValidPingTrasmission) {
        this.lastValidRequestTimeNs = lastValidPingTrasmission;
    }

    public long getLastValidPostRequestTimeNs() {
        return this.lastValidRequestTimeNs;
    }
}

