/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.logging.NetworkFriendlyExceptions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.FilteringConfiguration;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.LiveMetricsRestAPIsForClientSDKs;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.IsSubscribedHeaders;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MonitoringDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

class QuickPulsePingSender {
    private static final long TICKS_AT_EPOCH = 621355968000000000L;
    private static final ClientLogger logger = new ClientLogger(QuickPulsePingSender.class);
    private static final OperationLogger operationLogger = new OperationLogger(QuickPulsePingSender.class, "Pinging live metrics endpoint");
    private static final AtomicBoolean friendlyExceptionThrown = new AtomicBoolean();
    private final LiveMetricsRestAPIsForClientSDKs liveMetricsRestAPIsForClientSDKs;
    private final Supplier<URL> endpointUrl;
    private final Supplier<String> instrumentationKey;
    private final String roleName;
    private final String instanceName;
    private final String machineName;
    private final String quickPulseId;
    private long lastValidRequestTimeNs = System.nanoTime();
    private final String sdkVersion;
    private final AtomicReference<FilteringConfiguration> configuration;
    private IsSubscribedHeaders responseHeaders;
    private static final HttpHeaderName QPS_STATUS_HEADER = HttpHeaderName.fromString((String)"x-ms-qps-subscribed");

    QuickPulsePingSender(LiveMetricsRestAPIsForClientSDKs liveMetricsRestAPIsForClientSDKs, Supplier<URL> endpointUrl, Supplier<String> instrumentationKey, String roleName, String instanceName, String machineName, String quickPulseId, String sdkVersion, AtomicReference<FilteringConfiguration> configuration) {
        this.liveMetricsRestAPIsForClientSDKs = liveMetricsRestAPIsForClientSDKs;
        this.endpointUrl = endpointUrl;
        this.instrumentationKey = instrumentationKey;
        this.roleName = roleName;
        this.instanceName = instanceName;
        this.machineName = machineName;
        this.quickPulseId = quickPulseId;
        this.sdkVersion = sdkVersion;
        this.responseHeaders = null;
        this.configuration = configuration;
    }

    IsSubscribedHeaders ping(String redirectedEndpoint) {
        String instrumentationKey = this.getInstrumentationKey();
        if (Strings.isNullOrEmpty(instrumentationKey)) {
            HttpHeaders headers = new HttpHeaders();
            headers.add(QPS_STATUS_HEADER, "false");
            return new IsSubscribedHeaders(headers);
        }
        Date currentDate = new Date();
        long transmissionTimeInTicks = currentDate.getTime() * 10000L + 621355968000000000L;
        String endpointPrefix = Strings.isNullOrEmpty(redirectedEndpoint) ? this.getQuickPulseEndpoint() : redirectedEndpoint;
        logger.verbose("About to ping quickpulse with the endpoint prefix: {}", new Object[]{endpointPrefix});
        long sendTime = System.nanoTime();
        try {
            CollectionConfigurationInfo body;
            Response responseMono = (Response)this.liveMetricsRestAPIsForClientSDKs.isSubscribedNoCustomHeadersWithResponseAsync(endpointPrefix, instrumentationKey, transmissionTimeInTicks, this.machineName, this.instanceName, this.quickPulseId, this.roleName, String.valueOf(5), "", this.buildMonitoringDataPoint()).block();
            if (responseMono == null) {
                throw new AssertionError((Object)"http response mono returned empty");
            }
            this.responseHeaders = new IsSubscribedHeaders(responseMono.getHeaders());
            String isSubscribed = this.responseHeaders.getXMsQpsSubscribed();
            if (!Strings.isNullOrEmpty(isSubscribed)) {
                operationLogger.recordSuccess();
                this.lastValidRequestTimeNs = sendTime;
            }
            if ((body = (CollectionConfigurationInfo)responseMono.getValue()) != null && !this.configuration.get().getETag().equals(body.getETag())) {
                try {
                    logger.verbose("Received a new live metrics filtering configuration from ping response: {}", new Object[]{body.toJsonString()});
                }
                catch (IOException e) {
                    logger.verbose(e.getMessage());
                }
                this.configuration.set(new FilteringConfiguration(body));
            }
            return this.responseHeaders;
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (!NetworkFriendlyExceptions.logSpecialOneTimeFriendlyException(t, endpointPrefix, friendlyExceptionThrown, logger)) {
                operationLogger.recordFailure(t.getMessage(), t, AzureMonitorMsgId.QUICK_PULSE_PING_ERROR);
            }
            return this.onPingError(sendTime);
        }
    }

    @Nullable
    public String getInstrumentationKey() {
        return this.instrumentationKey.get();
    }

    String getQuickPulseEndpoint() {
        return this.endpointUrl.get().toString();
    }

    private MonitoringDataPoint buildMonitoringDataPoint() {
        MonitoringDataPoint dataPoint = new MonitoringDataPoint();
        dataPoint.setInstance(this.instanceName);
        dataPoint.setInvariantVersion(5);
        dataPoint.setMachineName(this.machineName);
        dataPoint.setRoleName(this.roleName);
        dataPoint.setStreamId(this.quickPulseId);
        dataPoint.setVersion(this.sdkVersion);
        return dataPoint;
    }

    private IsSubscribedHeaders onPingError(long sendTime) {
        HttpHeaders headers = new HttpHeaders();
        double timeFromlastValidRequestTimeNs = (double)(sendTime - this.lastValidRequestTimeNs) / 1.0E9;
        if (timeFromlastValidRequestTimeNs >= 60.0) {
            return new IsSubscribedHeaders(headers);
        }
        headers.add(QPS_STATUS_HEADER, "false");
        return new IsSubscribedHeaders(headers);
    }

    public long getLastValidPingTransmissionNs() {
        return this.lastValidRequestTimeNs;
    }

    public void resetLastValidRequestTimeNs(long lastValidPostTrasmission) {
        this.lastValidRequestTimeNs = lastValidPostTrasmission;
    }
}

