/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.RemoteDependencyData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.CustomDimensions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.FormattedDuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DependencyDataColumns
implements TelemetryColumns {
    private final CustomDimensions customDims;
    private final Map<String, Object> mapping = new HashMap<String, Object>();
    private static final ClientLogger LOGGER = new ClientLogger(DependencyDataColumns.class);

    public DependencyDataColumns(RemoteDependencyData rdData) {
        int resultCode;
        this.customDims = new CustomDimensions(rdData.getProperties(), rdData.getMeasurements());
        this.mapping.put("Target", rdData.getTarget());
        long durationMicroSec = FormattedDuration.getDurationFromTelemetryItemDurationString(rdData.getDuration());
        if (durationMicroSec == -1L) {
            LOGGER.verbose("The provided timestamp {} could not be converted to microseconds", new Object[]{rdData.getDuration()});
        }
        this.mapping.put("Duration", durationMicroSec);
        this.mapping.put("Success", rdData.isSuccess());
        this.mapping.put("Name", rdData.getName());
        try {
            resultCode = Integer.parseInt(rdData.getResultCode());
        }
        catch (NumberFormatException e) {
            LOGGER.verbose("The provided result code {} could not be converted to a numeric value", new Object[]{rdData.getResultCode()});
            resultCode = -1;
        }
        this.mapping.put("ResultCode", resultCode);
        this.mapping.put("Type", rdData.getType());
        this.mapping.put("Data", rdData.getData());
    }

    public DependencyDataColumns(String target, long duration, boolean success, String name, int resultCode, String type, String data, Map<String, String> dims, Map<String, Double> measurements) {
        this.customDims = new CustomDimensions(dims, measurements);
        this.mapping.put("Target", target);
        this.mapping.put("Duration", duration);
        this.mapping.put("Success", success);
        this.mapping.put("Name", name);
        this.mapping.put("ResultCode", resultCode);
        this.mapping.put("Type", type);
        this.mapping.put("Data", data);
    }

    @Override
    public <T> T getFieldValue(String fieldName, Class<T> type) {
        return type.cast(this.mapping.get(fieldName));
    }

    @Override
    public List<String> getAllFieldValuesAsString() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : this.mapping.values()) {
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            if (value instanceof Integer) {
                result.add(((Integer)value).toString());
                continue;
            }
            if (value instanceof Long) {
                result.add(((Long)value).toString());
                continue;
            }
            result.add(((Boolean)value).toString());
        }
        return result;
    }

    @Override
    public boolean checkAllCustomDims(FilterInfo filter, TelemetryColumns data) {
        return this.customDims.matchesAnyFieldInCustomDimensions(filter);
    }

    @Override
    public boolean checkCustomDimFilter(FilterInfo filter, TelemetryColumns data, String trimmedFieldName) {
        return this.customDims.matchesCustomDimFilter(filter, trimmedFieldName);
    }

    @Override
    public double getCustomDimValueForProjection(String key) {
        return this.customDims.getCustomDimValueForProjection(key);
    }
}

