/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DerivedMetricInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterConjunctionGroupInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.PredicateType;
import java.util.List;

public class Filter {
    public static final String CUSTOM_DIM_FIELDNAME_PREFIX = "CustomDimensions.";
    public static final String ANY_FIELD = "*";

    public static boolean checkMetricFilters(DerivedMetricInfo derivedMetricInfo, TelemetryColumns data) {
        if (derivedMetricInfo.getFilterGroups().isEmpty()) {
            return true;
        }
        boolean matched = false;
        for (FilterConjunctionGroupInfo filterGroup : derivedMetricInfo.getFilterGroups()) {
            matched = matched || Filter.checkFilterConjunctionGroup(filterGroup, data);
        }
        return matched;
    }

    public static boolean checkFilterConjunctionGroup(FilterConjunctionGroupInfo filterConjunctionGroupInfo, TelemetryColumns data) {
        for (FilterInfo filter : filterConjunctionGroupInfo.getFilters()) {
            if (Filter.checkFilter(filter, data)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFilter(FilterInfo filter, TelemetryColumns data) {
        if (ANY_FIELD.equals(filter.getFieldName())) {
            return Filter.checkAnyFieldFilter(filter, data);
        }
        if (filter.getFieldName().startsWith(CUSTOM_DIM_FIELDNAME_PREFIX)) {
            return Filter.checkCustomDimFilter(filter, data);
        }
        String fieldName = filter.getFieldName();
        if (filter.getFieldName().equals("Success")) {
            boolean fieldValueBoolean = data.getFieldValue(filter.getFieldName(), Boolean.class);
            boolean comparand = Boolean.parseBoolean(filter.getComparand().toLowerCase());
            if (filter.getPredicate().equals((Object)PredicateType.EQUAL)) {
                return fieldValueBoolean == comparand;
            }
            if (filter.getPredicate().equals((Object)PredicateType.NOT_EQUAL)) {
                return fieldValueBoolean != comparand;
            }
        } else {
            if (filter.getFieldName().equals("Duration")) {
                long comparand = Filter.getMicroSecondsFromFilterTimestampString(filter.getComparand());
                long fieldValueLong = data.getFieldValue("Duration", Long.class);
                return Filter.numericCompare(fieldValueLong, comparand, filter.getPredicate());
            }
            if (filter.getFieldName().equals("ResultCode") || filter.getFieldName().equals("ResponseCode")) {
                int comparand = Integer.parseInt(filter.getComparand());
                PredicateType predicate = filter.getPredicate();
                int fieldValueInt = data.getFieldValue(fieldName, Integer.class);
                return Filter.numericCompare(fieldValueInt, comparand, predicate);
            }
            String fieldValueString = data.getFieldValue(fieldName, String.class);
            return Filter.stringCompare(fieldValueString, filter.getComparand(), filter.getPredicate());
        }
        return false;
    }

    private static boolean checkAnyFieldFilter(FilterInfo filter, TelemetryColumns data) {
        List<String> values = data.getAllFieldValuesAsString();
        for (String value : values) {
            if (!Filter.stringCompare(value, filter.getComparand(), filter.getPredicate())) continue;
            return true;
        }
        return data.checkAllCustomDims(filter, data);
    }

    private static boolean checkCustomDimFilter(FilterInfo filter, TelemetryColumns data) {
        String fieldName = filter.getFieldName().replace(CUSTOM_DIM_FIELDNAME_PREFIX, "");
        return data.checkCustomDimFilter(filter, data, fieldName);
    }

    public static boolean stringCompare(String fieldValue, String comparand, PredicateType predicate) {
        if (predicate.equals((Object)PredicateType.EQUAL)) {
            return fieldValue != null && fieldValue.equals(comparand);
        }
        if (predicate.equals((Object)PredicateType.NOT_EQUAL)) {
            return fieldValue != null && !fieldValue.equals(comparand);
        }
        if (predicate.equals((Object)PredicateType.CONTAINS)) {
            return fieldValue != null && fieldValue.toLowerCase().contains(comparand.toLowerCase());
        }
        if (predicate.equals((Object)PredicateType.DOES_NOT_CONTAIN)) {
            return fieldValue != null && !fieldValue.toLowerCase().contains(comparand.toLowerCase());
        }
        return false;
    }

    private static boolean numericCompare(long fieldValue, long comparand, PredicateType predicate) {
        if (predicate.equals((Object)PredicateType.EQUAL)) {
            return fieldValue == comparand;
        }
        if (predicate.equals((Object)PredicateType.NOT_EQUAL)) {
            return fieldValue != comparand;
        }
        if (predicate.equals((Object)PredicateType.GREATER_THAN)) {
            return fieldValue > comparand;
        }
        if (predicate.equals((Object)PredicateType.GREATER_THAN_OR_EQUAL)) {
            return fieldValue >= comparand;
        }
        if (predicate.equals((Object)PredicateType.LESS_THAN)) {
            return fieldValue < comparand;
        }
        if (predicate.equals((Object)PredicateType.LESS_THAN_OR_EQUAL)) {
            return fieldValue <= comparand;
        }
        return false;
    }

    public static long getMicroSecondsFromFilterTimestampString(String timestamp) {
        String[] parts = timestamp.split(":");
        if (parts.length != 3) {
            return Long.MIN_VALUE;
        }
        long microseconds = (long)(Double.parseDouble(parts[2]) * 1000000.0);
        int minutes = Filter.parseInt(parts[1]);
        String[] firstPart = parts[0].split("\\.");
        if (firstPart.length != 2) {
            return Long.MIN_VALUE;
        }
        int hours = Filter.parseInt(firstPart[1]);
        int days = Filter.parseInt(firstPart[0]);
        if (minutes == Integer.MIN_VALUE || hours == Integer.MIN_VALUE || days == Integer.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return microseconds + (long)minutes * 60L * 1000000L + (long)hours * 60L * 60L * 1000000L + (long)days * 24L * 60L * 60L * 1000000L;
    }

    private static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }
}

