/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.ConfigErrorTracker;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.Validator;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.AggregationType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationError;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DerivedMetricInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentFilterConjunctionGroupInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentStreamInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterConjunctionGroupInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.TelemetryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FilteringConfiguration {
    private final Map<TelemetryType, List<DerivedMetricInfo>> validDerivedMetricInfos;
    private final Map<TelemetryType, Map<String, List<FilterConjunctionGroupInfo>>> validDocumentFilterConjunctionGroupInfos;
    private final String etag;
    private final Map<String, AggregationType> validProjectionInfo;
    private final Validator validator = new Validator();
    private final ConfigErrorTracker errorTracker = new ConfigErrorTracker();
    private static final ClientLogger logger = new ClientLogger(FilteringConfiguration.class);

    public FilteringConfiguration() {
        this.validDerivedMetricInfos = new HashMap<TelemetryType, List<DerivedMetricInfo>>();
        this.validDocumentFilterConjunctionGroupInfos = new HashMap<TelemetryType, Map<String, List<FilterConjunctionGroupInfo>>>();
        this.etag = "";
        this.validProjectionInfo = new HashMap<String, AggregationType>();
        logger.verbose("Initializing an empty live metrics filtering configuration - did not yet receive a configuration from ping or post.");
    }

    public FilteringConfiguration(CollectionConfigurationInfo configuration) {
        logger.verbose("About to parse and validate a new live metrics filtering configuration with etag {}", new Object[]{configuration.getETag()});
        this.validDerivedMetricInfos = this.parseMetricFilterConfiguration(configuration);
        this.validDocumentFilterConjunctionGroupInfos = this.parseDocumentFilterConfiguration(configuration);
        this.etag = configuration.getETag();
        this.validProjectionInfo = this.initValidProjectionInfo();
    }

    public List<DerivedMetricInfo> fetchMetricConfigForTelemetryType(TelemetryType telemetryType) {
        if (this.validDerivedMetricInfos.containsKey((Object)telemetryType)) {
            return new ArrayList<DerivedMetricInfo>((Collection)this.validDerivedMetricInfos.get((Object)telemetryType));
        }
        return new ArrayList<DerivedMetricInfo>();
    }

    public Map<String, List<FilterConjunctionGroupInfo>> fetchDocumentsConfigForTelemetryType(TelemetryType telemetryType) {
        HashMap<String, List<FilterConjunctionGroupInfo>> result = this.validDocumentFilterConjunctionGroupInfos.containsKey((Object)telemetryType) ? new HashMap<String, List<FilterConjunctionGroupInfo>>(this.validDocumentFilterConjunctionGroupInfos.get((Object)telemetryType)) : new HashMap<String, List<FilterConjunctionGroupInfo>>();
        return result;
    }

    public String getETag() {
        return this.etag;
    }

    public Map<String, AggregationType> getValidProjectionInitInfo() {
        return new HashMap<String, AggregationType>(this.validProjectionInfo);
    }

    public List<CollectionConfigurationError> getErrors() {
        return this.errorTracker.getErrors();
    }

    private Map<TelemetryType, Map<String, List<FilterConjunctionGroupInfo>>> parseDocumentFilterConfiguration(CollectionConfigurationInfo configuration) {
        HashMap<TelemetryType, Map<String, List<FilterConjunctionGroupInfo>>> result = new HashMap<TelemetryType, Map<String, List<FilterConjunctionGroupInfo>>>();
        for (DocumentStreamInfo documentStreamInfo : configuration.getDocumentStreams()) {
            String documentStreamId = documentStreamInfo.getId();
            for (DocumentFilterConjunctionGroupInfo documentFilterGroupInfo : documentStreamInfo.getDocumentFilterGroups()) {
                Map innerMap;
                TelemetryType telemetryType = documentFilterGroupInfo.getTelemetryType();
                FilterConjunctionGroupInfo filterGroup = documentFilterGroupInfo.getFilters();
                Optional<String> docFilterGroupError = this.validator.validateDocConjunctionGroupInfo(documentFilterGroupInfo);
                if (docFilterGroupError.isPresent()) {
                    this.errorTracker.addError(docFilterGroupError.get(), configuration.getETag(), documentStreamId, false);
                    continue;
                }
                if (!result.containsKey((Object)telemetryType)) {
                    result.put(telemetryType, new HashMap());
                }
                if ((innerMap = (Map)result.get((Object)telemetryType)).containsKey(documentStreamId)) {
                    ((List)innerMap.get(documentStreamId)).add(filterGroup);
                    continue;
                }
                ArrayList<FilterConjunctionGroupInfo> filterGroups = new ArrayList<FilterConjunctionGroupInfo>();
                filterGroups.add(filterGroup);
                innerMap.put(documentStreamId, filterGroups);
            }
        }
        return result;
    }

    private Map<TelemetryType, List<DerivedMetricInfo>> parseMetricFilterConfiguration(CollectionConfigurationInfo configuration) {
        HashSet<String> seenMetricIds = new HashSet<String>();
        HashMap<TelemetryType, List<DerivedMetricInfo>> result = new HashMap<TelemetryType, List<DerivedMetricInfo>>();
        for (DerivedMetricInfo derivedMetricInfo : configuration.getMetrics()) {
            TelemetryType telemetryType = TelemetryType.fromString(derivedMetricInfo.getTelemetryType());
            String id = derivedMetricInfo.getId();
            if (!seenMetricIds.contains(id)) {
                seenMetricIds.add(id);
                Optional<String> dmiError = this.validator.validateDerivedMetricInfo(derivedMetricInfo);
                if (dmiError.isPresent()) {
                    this.errorTracker.addError(dmiError.get(), configuration.getETag(), id, true);
                    continue;
                }
                if (result.containsKey((Object)telemetryType)) {
                    ((List)result.get((Object)telemetryType)).add(derivedMetricInfo);
                    continue;
                }
                ArrayList<DerivedMetricInfo> infos = new ArrayList<DerivedMetricInfo>();
                infos.add(derivedMetricInfo);
                result.put(telemetryType, infos);
                continue;
            }
            this.errorTracker.addError("A duplicate metric id was found in this configuration", configuration.getETag(), id, true);
        }
        return result;
    }

    private Map<String, AggregationType> initValidProjectionInfo() {
        HashMap<String, AggregationType> result = new HashMap<String, AggregationType>();
        for (List<DerivedMetricInfo> derivedMetricInfoList : this.validDerivedMetricInfos.values()) {
            for (DerivedMetricInfo derivedMetricInfo : derivedMetricInfoList) {
                result.put(derivedMetricInfo.getId(), derivedMetricInfo.getAggregation());
            }
        }
        return result;
    }
}

