/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MessageData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.CustomDimensions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceDataColumns
implements TelemetryColumns {
    private final Map<String, Object> mapping = new HashMap<String, Object>();
    private final CustomDimensions customDims;

    public TraceDataColumns(MessageData traceData) {
        this.customDims = new CustomDimensions(traceData.getProperties(), traceData.getMeasurements());
        this.mapping.put("Message", traceData.getMessage());
    }

    public TraceDataColumns(String message, Map<String, String> dims, Map<String, Double> measurements) {
        this.customDims = new CustomDimensions(dims, measurements);
        this.mapping.put("Message", message);
    }

    @Override
    public boolean checkAllCustomDims(FilterInfo filter, TelemetryColumns data) {
        return this.customDims.matchesAnyFieldInCustomDimensions(filter);
    }

    @Override
    public boolean checkCustomDimFilter(FilterInfo filter, TelemetryColumns data, String trimmedFieldName) {
        return this.customDims.matchesCustomDimFilter(filter, trimmedFieldName);
    }

    @Override
    public <T> T getFieldValue(String fieldName, Class<T> type) {
        return type.cast(this.mapping.get(fieldName));
    }

    @Override
    public List<String> getAllFieldValuesAsString() {
        ArrayList<String> result = new ArrayList<String>();
        result.add((String)this.mapping.get("Message"));
        return result;
    }

    @Override
    public double getCustomDimValueForProjection(String key) {
        return this.customDims.getCustomDimValueForProjection(key);
    }
}

