/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.Filter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DerivedMetricInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentFilterConjunctionGroupInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterConjunctionGroupInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.PredicateType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.TelemetryType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class Validator {
    private final Set<String> knownStringColumns = new HashSet<String>(Arrays.asList("Url", "Name", "Data", "Target", "Type", "Message", "Exception.Message", "Exception.StackTrace"));
    private final Set<String> knownNumericColumns = new HashSet<String>(Arrays.asList("ResponseCode", "Duration", "ResultCode"));
    private final Set<PredicateType> validStringPredicates = new HashSet<PredicateType>(Arrays.asList(PredicateType.CONTAINS, PredicateType.DOES_NOT_CONTAIN, PredicateType.EQUAL, PredicateType.NOT_EQUAL));

    public Optional<String> validateDerivedMetricInfo(DerivedMetricInfo derivedMetricInfo) {
        TelemetryType telemetryType = TelemetryType.fromString(derivedMetricInfo.getTelemetryType());
        if (!this.isValidTelemetryType(telemetryType)) {
            return Optional.of("The user selected a telemetry type that the SDK does not support for Live Metrics Filtering. Telemetry type: " + (Object)((Object)telemetryType));
        }
        if (!this.isNotCustomMetricProjection(derivedMetricInfo.getProjection())) {
            return Optional.of("The user selected a projection of Custom Metric, which this SDK does not support.");
        }
        for (FilterConjunctionGroupInfo conjunctionGroupInfo : derivedMetricInfo.getFilterGroups()) {
            for (FilterInfo filter : conjunctionGroupInfo.getFilters()) {
                Optional<String> error = this.validateFieldName(filter.getFieldName());
                if (error.isPresent()) {
                    return error;
                }
                error = this.validatePredicateAndComparand(filter);
                if (!error.isPresent()) continue;
                return error;
            }
        }
        return Optional.empty();
    }

    public Optional<String> validateDocConjunctionGroupInfo(DocumentFilterConjunctionGroupInfo documentFilterConjunctionGroupInfo) {
        TelemetryType telemetryType = documentFilterConjunctionGroupInfo.getTelemetryType();
        if (!this.isValidTelemetryType(telemetryType)) {
            return Optional.of("The user selected a telemetry type that the SDK does not support for Live Metrics Filtering. Telemetry type: " + (Object)((Object)telemetryType));
        }
        FilterConjunctionGroupInfo conjunctionGroupInfo = documentFilterConjunctionGroupInfo.getFilters();
        for (FilterInfo filter : conjunctionGroupInfo.getFilters()) {
            Optional<String> error = this.validateFieldName(filter.getFieldName());
            if (error.isPresent()) {
                return error;
            }
            error = this.validatePredicateAndComparand(filter);
            if (!error.isPresent()) continue;
            return error;
        }
        return Optional.empty();
    }

    private boolean isValidTelemetryType(TelemetryType telemetryType) {
        if (telemetryType.equals((Object)TelemetryType.PERFORMANCE_COUNTER)) {
            return false;
        }
        if (telemetryType.equals((Object)TelemetryType.EVENT)) {
            return false;
        }
        return !telemetryType.equals((Object)TelemetryType.METRIC);
    }

    private boolean isNotCustomMetricProjection(String projection) {
        return !projection.startsWith("CustomMetrics.");
    }

    private Optional<String> validateFieldName(String fieldName) {
        if (fieldName.isEmpty()) {
            return Optional.of("The user specified an empty field name for a filter.");
        }
        if (fieldName.startsWith("CustomMetrics.")) {
            return Optional.of("The user selected a custom metric field name, but this SDK does not support filtering of custom metrics.");
        }
        return Optional.empty();
    }

    private Optional<String> validatePredicateAndComparand(FilterInfo filter) {
        if (filter.getComparand().isEmpty()) {
            return Optional.of("The user specified an empty comparand value for a filter.");
        }
        if ("*".equals(filter.getFieldName()) && !filter.getPredicate().equals((Object)PredicateType.CONTAINS) && !filter.getPredicate().equals((Object)PredicateType.DOES_NOT_CONTAIN)) {
            return Optional.of("The specified predicate is not supported for the fieldName * (Any field): " + filter.getPredicate().getValue());
        }
        if (this.knownNumericColumns.contains(filter.getFieldName())) {
            if ("Duration".equals(filter.getFieldName())) {
                if (Filter.getMicroSecondsFromFilterTimestampString(filter.getComparand()) == Long.MIN_VALUE) {
                    return Optional.of("The duration string provided by the user could not be parsed to a numeric value: " + filter.getComparand());
                }
            } else {
                try {
                    Long.parseLong(filter.getComparand());
                }
                catch (NumberFormatException e) {
                    return Optional.of("The result/response code specified by the user did not parse to a numeric value: " + filter.getComparand());
                }
            }
        } else if ((this.knownStringColumns.contains(filter.getFieldName()) || filter.getFieldName().startsWith("CustomDimensions.")) && !this.validStringPredicates.contains((Object)filter.getPredicate())) {
            return Optional.of("The user selected a predicate (" + filter.getPredicate().getValue() + ") that is not supported for the field name " + filter.getFieldName());
        }
        return Optional.empty();
    }
}

