/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DerivedMetricInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentStreamInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.QuotaConfigurationInfo;
import java.io.IOException;
import java.util.List;

public final class CollectionConfigurationInfo
implements JsonSerializable<CollectionConfigurationInfo> {
    private String eTag;
    private List<DerivedMetricInfo> metrics;
    private List<DocumentStreamInfo> documentStreams;
    private QuotaConfigurationInfo quotaInfo;

    public String getETag() {
        return this.eTag;
    }

    public CollectionConfigurationInfo setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public List<DerivedMetricInfo> getMetrics() {
        return this.metrics;
    }

    public CollectionConfigurationInfo setMetrics(List<DerivedMetricInfo> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<DocumentStreamInfo> getDocumentStreams() {
        return this.documentStreams;
    }

    public CollectionConfigurationInfo setDocumentStreams(List<DocumentStreamInfo> documentStreams) {
        this.documentStreams = documentStreams;
        return this;
    }

    public QuotaConfigurationInfo getQuotaInfo() {
        return this.quotaInfo;
    }

    public CollectionConfigurationInfo setQuotaInfo(QuotaConfigurationInfo quotaInfo) {
        this.quotaInfo = quotaInfo;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ETag", this.eTag);
        jsonWriter.writeArrayField("Metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("DocumentStreams", this.documentStreams, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("QuotaInfo", (JsonSerializable)this.quotaInfo);
        return jsonWriter.writeEndObject();
    }

    public static CollectionConfigurationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (CollectionConfigurationInfo)jsonReader.readObject(reader -> {
            CollectionConfigurationInfo deserializedCollectionConfigurationInfo = new CollectionConfigurationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ETag".equals(fieldName)) {
                    deserializedCollectionConfigurationInfo.eTag = reader.getString();
                    continue;
                }
                if ("Metrics".equals(fieldName)) {
                    List metrics;
                    deserializedCollectionConfigurationInfo.metrics = metrics = reader.readArray(reader1 -> DerivedMetricInfo.fromJson(reader1));
                    continue;
                }
                if ("DocumentStreams".equals(fieldName)) {
                    List documentStreams;
                    deserializedCollectionConfigurationInfo.documentStreams = documentStreams = reader.readArray(reader1 -> DocumentStreamInfo.fromJson(reader1));
                    continue;
                }
                if ("QuotaInfo".equals(fieldName)) {
                    deserializedCollectionConfigurationInfo.quotaInfo = QuotaConfigurationInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCollectionConfigurationInfo;
        });
    }
}

