/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import java.io.IOException;
import java.util.List;

public final class Exception
extends DocumentIngress {
    private DocumentType documentType = DocumentType.EXCEPTION;
    private String exceptionType;
    private String exceptionMessage;

    @Override
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public Exception setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
        return this;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public Exception setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Override
    public Exception setDocumentStreamIds(List<String> documentStreamIds) {
        super.setDocumentStreamIds(documentStreamIds);
        return this;
    }

    @Override
    public Exception setProperties(List<KeyValuePairString> properties) {
        super.setProperties(properties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("DocumentStreamIds", this.getDocumentStreamIds(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("Properties", this.getProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("DocumentType", this.documentType == null ? null : this.documentType.toString());
        jsonWriter.writeStringField("ExceptionType", this.exceptionType);
        jsonWriter.writeStringField("ExceptionMessage", this.exceptionMessage);
        return jsonWriter.writeEndObject();
    }

    public static Exception fromJson(JsonReader jsonReader) throws IOException {
        return (Exception)jsonReader.readObject(reader -> {
            Exception deserializedException = new Exception();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DocumentStreamIds".equals(fieldName)) {
                    List documentStreamIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedException.setDocumentStreamIds(documentStreamIds);
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    List properties = reader.readArray(reader1 -> KeyValuePairString.fromJson(reader1));
                    deserializedException.setProperties(properties);
                    continue;
                }
                if ("DocumentType".equals(fieldName)) {
                    deserializedException.documentType = DocumentType.fromString(reader.getString());
                    continue;
                }
                if ("ExceptionType".equals(fieldName)) {
                    deserializedException.exceptionType = reader.getString();
                    continue;
                }
                if ("ExceptionMessage".equals(fieldName)) {
                    deserializedException.exceptionMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedException;
        });
    }
}

