/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationError;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MetricPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.ProcessCpuData;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class MonitoringDataPoint
implements JsonSerializable<MonitoringDataPoint> {
    private String version;
    private int invariantVersion;
    private String instance;
    private String roleName;
    private String machineName;
    private String streamId;
    private OffsetDateTime timestamp;
    private OffsetDateTime transmissionTime;
    private boolean isWebApp;
    private boolean performanceCollectionSupported;
    private List<MetricPoint> metrics;
    private List<DocumentIngress> documents;
    private List<ProcessCpuData> topCpuProcesses;
    private List<CollectionConfigurationError> collectionConfigurationErrors;

    public String getVersion() {
        return this.version;
    }

    public MonitoringDataPoint setVersion(String version) {
        this.version = version;
        return this;
    }

    public int getInvariantVersion() {
        return this.invariantVersion;
    }

    public MonitoringDataPoint setInvariantVersion(int invariantVersion) {
        this.invariantVersion = invariantVersion;
        return this;
    }

    public String getInstance() {
        return this.instance;
    }

    public MonitoringDataPoint setInstance(String instance) {
        this.instance = instance;
        return this;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public MonitoringDataPoint setRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public MonitoringDataPoint setMachineName(String machineName) {
        this.machineName = machineName;
        return this;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public MonitoringDataPoint setStreamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public MonitoringDataPoint setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public OffsetDateTime getTransmissionTime() {
        return this.transmissionTime;
    }

    public MonitoringDataPoint setTransmissionTime(OffsetDateTime transmissionTime) {
        this.transmissionTime = transmissionTime;
        return this;
    }

    public boolean isWebApp() {
        return this.isWebApp;
    }

    public MonitoringDataPoint setIsWebApp(boolean isWebApp) {
        this.isWebApp = isWebApp;
        return this;
    }

    public boolean isPerformanceCollectionSupported() {
        return this.performanceCollectionSupported;
    }

    public MonitoringDataPoint setPerformanceCollectionSupported(boolean performanceCollectionSupported) {
        this.performanceCollectionSupported = performanceCollectionSupported;
        return this;
    }

    public List<MetricPoint> getMetrics() {
        return this.metrics;
    }

    public MonitoringDataPoint setMetrics(List<MetricPoint> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<DocumentIngress> getDocuments() {
        return this.documents;
    }

    public MonitoringDataPoint setDocuments(List<DocumentIngress> documents) {
        this.documents = documents;
        return this;
    }

    public List<ProcessCpuData> getTopCpuProcesses() {
        return this.topCpuProcesses;
    }

    public MonitoringDataPoint setTopCpuProcesses(List<ProcessCpuData> topCpuProcesses) {
        this.topCpuProcesses = topCpuProcesses;
        return this;
    }

    public List<CollectionConfigurationError> getCollectionConfigurationErrors() {
        return this.collectionConfigurationErrors;
    }

    public MonitoringDataPoint setCollectionConfigurationErrors(List<CollectionConfigurationError> collectionConfigurationErrors) {
        this.collectionConfigurationErrors = collectionConfigurationErrors;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("Version", this.version);
        jsonWriter.writeIntField("InvariantVersion", this.invariantVersion);
        jsonWriter.writeStringField("Instance", this.instance);
        jsonWriter.writeStringField("RoleName", this.roleName);
        jsonWriter.writeStringField("MachineName", this.machineName);
        jsonWriter.writeStringField("StreamId", this.streamId);
        jsonWriter.writeBooleanField("IsWebApp", this.isWebApp);
        jsonWriter.writeBooleanField("PerformanceCollectionSupported", this.performanceCollectionSupported);
        jsonWriter.writeStringField("Timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("TransmissionTime", this.transmissionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.transmissionTime));
        jsonWriter.writeArrayField("Metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("Documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("TopCpuProcesses", this.topCpuProcesses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("CollectionConfigurationErrors", this.collectionConfigurationErrors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MonitoringDataPoint fromJson(JsonReader jsonReader) throws IOException {
        return (MonitoringDataPoint)jsonReader.readObject(reader -> {
            MonitoringDataPoint deserializedMonitoringDataPoint = new MonitoringDataPoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Version".equals(fieldName)) {
                    deserializedMonitoringDataPoint.version = reader.getString();
                    continue;
                }
                if ("InvariantVersion".equals(fieldName)) {
                    deserializedMonitoringDataPoint.invariantVersion = reader.getInt();
                    continue;
                }
                if ("Instance".equals(fieldName)) {
                    deserializedMonitoringDataPoint.instance = reader.getString();
                    continue;
                }
                if ("RoleName".equals(fieldName)) {
                    deserializedMonitoringDataPoint.roleName = reader.getString();
                    continue;
                }
                if ("MachineName".equals(fieldName)) {
                    deserializedMonitoringDataPoint.machineName = reader.getString();
                    continue;
                }
                if ("StreamId".equals(fieldName)) {
                    deserializedMonitoringDataPoint.streamId = reader.getString();
                    continue;
                }
                if ("IsWebApp".equals(fieldName)) {
                    deserializedMonitoringDataPoint.isWebApp = reader.getBoolean();
                    continue;
                }
                if ("PerformanceCollectionSupported".equals(fieldName)) {
                    deserializedMonitoringDataPoint.performanceCollectionSupported = reader.getBoolean();
                    continue;
                }
                if ("Timestamp".equals(fieldName)) {
                    deserializedMonitoringDataPoint.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("TransmissionTime".equals(fieldName)) {
                    deserializedMonitoringDataPoint.transmissionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("Metrics".equals(fieldName)) {
                    List metrics;
                    deserializedMonitoringDataPoint.metrics = metrics = reader.readArray(reader1 -> MetricPoint.fromJson(reader1));
                    continue;
                }
                if ("Documents".equals(fieldName)) {
                    List documents;
                    deserializedMonitoringDataPoint.documents = documents = reader.readArray(reader1 -> DocumentIngress.fromJson(reader1));
                    continue;
                }
                if ("TopCpuProcesses".equals(fieldName)) {
                    List topCpuProcesses;
                    deserializedMonitoringDataPoint.topCpuProcesses = topCpuProcesses = reader.readArray(reader1 -> ProcessCpuData.fromJson(reader1));
                    continue;
                }
                if ("CollectionConfigurationErrors".equals(fieldName)) {
                    List collectionConfigurationErrors;
                    deserializedMonitoringDataPoint.collectionConfigurationErrors = collectionConfigurationErrors = reader.readArray(reader1 -> CollectionConfigurationError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonitoringDataPoint;
        });
    }
}

