/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import java.io.IOException;
import java.util.List;

public final class RemoteDependency
extends DocumentIngress {
    private DocumentType documentType = DocumentType.REMOTE_DEPENDENCY;
    private String name;
    private String commandName;
    private String resultCode;
    private String duration;

    @Override
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getName() {
        return this.name;
    }

    public RemoteDependency setName(String name) {
        this.name = name;
        return this;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public RemoteDependency setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public RemoteDependency setResultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public RemoteDependency setDuration(String duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public RemoteDependency setDocumentStreamIds(List<String> documentStreamIds) {
        super.setDocumentStreamIds(documentStreamIds);
        return this;
    }

    @Override
    public RemoteDependency setProperties(List<KeyValuePairString> properties) {
        super.setProperties(properties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("DocumentStreamIds", this.getDocumentStreamIds(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("Properties", this.getProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("DocumentType", this.documentType == null ? null : this.documentType.toString());
        jsonWriter.writeStringField("Name", this.name);
        jsonWriter.writeStringField("CommandName", this.commandName);
        jsonWriter.writeStringField("ResultCode", this.resultCode);
        jsonWriter.writeStringField("Duration", this.duration);
        return jsonWriter.writeEndObject();
    }

    public static RemoteDependency fromJson(JsonReader jsonReader) throws IOException {
        return (RemoteDependency)jsonReader.readObject(reader -> {
            RemoteDependency deserializedRemoteDependency = new RemoteDependency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DocumentStreamIds".equals(fieldName)) {
                    List documentStreamIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedRemoteDependency.setDocumentStreamIds(documentStreamIds);
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    List properties = reader.readArray(reader1 -> KeyValuePairString.fromJson(reader1));
                    deserializedRemoteDependency.setProperties(properties);
                    continue;
                }
                if ("DocumentType".equals(fieldName)) {
                    deserializedRemoteDependency.documentType = DocumentType.fromString(reader.getString());
                    continue;
                }
                if ("Name".equals(fieldName)) {
                    deserializedRemoteDependency.name = reader.getString();
                    continue;
                }
                if ("CommandName".equals(fieldName)) {
                    deserializedRemoteDependency.commandName = reader.getString();
                    continue;
                }
                if ("ResultCode".equals(fieldName)) {
                    deserializedRemoteDependency.resultCode = reader.getString();
                    continue;
                }
                if ("Duration".equals(fieldName)) {
                    deserializedRemoteDependency.duration = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemoteDependency;
        });
    }
}

