/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import java.io.IOException;
import java.util.List;

public final class Request
extends DocumentIngress {
    private DocumentType documentType = DocumentType.REQUEST;
    private String name;
    private String url;
    private String responseCode;
    private String duration;

    @Override
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getName() {
        return this.name;
    }

    public Request setName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Request setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public Request setResponseCode(String responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public Request setDuration(String duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public Request setDocumentStreamIds(List<String> documentStreamIds) {
        super.setDocumentStreamIds(documentStreamIds);
        return this;
    }

    @Override
    public Request setProperties(List<KeyValuePairString> properties) {
        super.setProperties(properties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("DocumentStreamIds", this.getDocumentStreamIds(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("Properties", this.getProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("DocumentType", this.documentType == null ? null : this.documentType.toString());
        jsonWriter.writeStringField("Name", this.name);
        jsonWriter.writeStringField("Url", this.url);
        jsonWriter.writeStringField("ResponseCode", this.responseCode);
        jsonWriter.writeStringField("Duration", this.duration);
        return jsonWriter.writeEndObject();
    }

    public static Request fromJson(JsonReader jsonReader) throws IOException {
        return (Request)jsonReader.readObject(reader -> {
            Request deserializedRequest = new Request();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DocumentStreamIds".equals(fieldName)) {
                    List documentStreamIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedRequest.setDocumentStreamIds(documentStreamIds);
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    List properties = reader.readArray(reader1 -> KeyValuePairString.fromJson(reader1));
                    deserializedRequest.setProperties(properties);
                    continue;
                }
                if ("DocumentType".equals(fieldName)) {
                    deserializedRequest.documentType = DocumentType.fromString(reader.getString());
                    continue;
                }
                if ("Name".equals(fieldName)) {
                    deserializedRequest.name = reader.getString();
                    continue;
                }
                if ("Url".equals(fieldName)) {
                    deserializedRequest.url = reader.getString();
                    continue;
                }
                if ("ResponseCode".equals(fieldName)) {
                    deserializedRequest.responseCode = reader.getString();
                    continue;
                }
                if ("Duration".equals(fieldName)) {
                    deserializedRequest.duration = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequest;
        });
    }
}

