/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import java.io.IOException;
import java.util.List;

public final class Trace
extends DocumentIngress {
    private DocumentType documentType = DocumentType.TRACE;
    private String message;

    @Override
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getMessage() {
        return this.message;
    }

    public Trace setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public Trace setDocumentStreamIds(List<String> documentStreamIds) {
        super.setDocumentStreamIds(documentStreamIds);
        return this;
    }

    @Override
    public Trace setProperties(List<KeyValuePairString> properties) {
        super.setProperties(properties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("DocumentStreamIds", this.getDocumentStreamIds(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("Properties", this.getProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("DocumentType", this.documentType == null ? null : this.documentType.toString());
        jsonWriter.writeStringField("Message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static Trace fromJson(JsonReader jsonReader) throws IOException {
        return (Trace)jsonReader.readObject(reader -> {
            Trace deserializedTrace = new Trace();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DocumentStreamIds".equals(fieldName)) {
                    List documentStreamIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedTrace.setDocumentStreamIds(documentStreamIds);
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    List properties = reader.readArray(reader1 -> KeyValuePairString.fromJson(reader1));
                    deserializedTrace.setProperties(properties);
                    continue;
                }
                if ("DocumentType".equals(fieldName)) {
                    deserializedTrace.documentType = DocumentType.fromString(reader.getString());
                    continue;
                }
                if ("Message".equals(fieldName)) {
                    deserializedTrace.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrace;
        });
    }
}

