/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;

enum ResourceProvider {
    RP_FUNCTIONS("functions"),
    RP_APPSVC("appsvc"),
    RP_VM("vm"),
    RP_AKS("aks"),
    RP_SPRING_CLOUD("springcloud"),
    UNKNOWN("unknown");

    private final String value;

    private ResourceProvider(String value) {
        this.value = value;
    }

    String getValue() {
        return this.value;
    }

    static ResourceProvider initResourceProvider() {
        if ("java".equals(System.getenv("FUNCTIONS_WORKER_RUNTIME"))) {
            return RP_FUNCTIONS;
        }
        if (!Strings.isNullOrEmpty(System.getenv("WEBSITE_SITE_NAME"))) {
            return RP_APPSVC;
        }
        if (!Strings.isNullOrEmpty(System.getenv("APPLICATIONINSIGHTS_SPRINGCLOUD_SERVICE_ID"))) {
            return RP_SPRING_CLOUD;
        }
        if (!Strings.isNullOrEmpty(System.getenv("KUBERNETES_SERVICE_HOST"))) {
            return RP_AKS;
        }
        return UNKNOWN;
    }
}

