/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.AttachStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.AzureMetadataService;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.BaseStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.CustomDimensions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.Feature;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.FeatureStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.FeatureType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.MetadataInstanceResponse;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.NetworkStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.NonessentialStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.ResourceProvider;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.RpAttachType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.AzureMonitorMsgId;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.ThreadPoolUtils;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class StatsbeatModule {
    private static final Logger logger = LoggerFactory.getLogger(BaseStatsbeat.class);
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(BaseStatsbeat.class));
    private final CustomDimensions customDimensions;
    private final NetworkStatsbeat networkStatsbeat;
    private final AttachStatsbeat attachStatsbeat;
    private final FeatureStatsbeat featureStatsbeat;
    private final FeatureStatsbeat instrumentationStatsbeat;
    private final NonessentialStatsbeat nonessentialStatsbeat;
    private final AzureMetadataService azureMetadataService;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public StatsbeatModule(Consumer<MetadataInstanceResponse> vmMetadataServiceCallback) {
        this.customDimensions = new CustomDimensions();
        this.attachStatsbeat = new AttachStatsbeat(this.customDimensions);
        this.featureStatsbeat = new FeatureStatsbeat(this.customDimensions, FeatureType.FEATURE);
        this.instrumentationStatsbeat = new FeatureStatsbeat(this.customDimensions, FeatureType.INSTRUMENTATION);
        this.azureMetadataService = new AzureMetadataService(this.attachStatsbeat, this.customDimensions, vmMetadataServiceCallback);
        if (RpAttachType.getRpAttachType() != RpAttachType.MANUAL) {
            this.networkStatsbeat = new NetworkStatsbeat(this.customDimensions);
            this.nonessentialStatsbeat = new NonessentialStatsbeat(this.customDimensions);
        } else {
            this.networkStatsbeat = null;
            this.nonessentialStatsbeat = null;
        }
    }

    public void start(TelemetryItemExporter telemetryItemExporter, Supplier<StatsbeatConnectionString> connectionString, Supplier<String> instrumentationKey, boolean disabledAll, long shortIntervalSeconds, long longIntervalSeconds, boolean disabled, Set<Feature> featureSet) {
        if (connectionString.get() == null) {
            logger.debug("Don't start StatsbeatModule when statsbeat connection string is null.");
            return;
        }
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("initialize already called");
        }
        if (disabledAll) {
            return;
        }
        this.updateConnectionString(connectionString.get());
        this.updateInstrumentationKey(instrumentationKey.get());
        if (RpAttachType.getRpAttachType() != RpAttachType.MANUAL) {
            this.scheduledExecutor.scheduleWithFixedDelay(new StatsbeatSender(this.networkStatsbeat, telemetryItemExporter), shortIntervalSeconds, shortIntervalSeconds, TimeUnit.SECONDS);
        }
        this.scheduledExecutor.scheduleWithFixedDelay(new StatsbeatSender(this.attachStatsbeat, telemetryItemExporter), Math.min(60L, longIntervalSeconds), longIntervalSeconds, TimeUnit.SECONDS);
        this.scheduledExecutor.scheduleWithFixedDelay(new StatsbeatSender(this.featureStatsbeat, telemetryItemExporter), Math.min(60L, longIntervalSeconds), longIntervalSeconds, TimeUnit.SECONDS);
        this.scheduledExecutor.scheduleWithFixedDelay(new StatsbeatSender(this.instrumentationStatsbeat, telemetryItemExporter), Math.min(60L, longIntervalSeconds), longIntervalSeconds, TimeUnit.SECONDS);
        ResourceProvider rp = this.customDimensions.getResourceProvider();
        if (rp == ResourceProvider.RP_VM || rp == ResourceProvider.UNKNOWN) {
            this.azureMetadataService.scheduleWithFixedDelay(longIntervalSeconds);
        }
        this.featureStatsbeat.trackConfigurationOptions(featureSet);
        if (!disabled && RpAttachType.getRpAttachType() != RpAttachType.MANUAL) {
            this.nonessentialStatsbeat.setConnectionString(connectionString.get());
            this.nonessentialStatsbeat.setInstrumentationKey(instrumentationKey.get());
            this.scheduledExecutor.scheduleWithFixedDelay(new StatsbeatSender(this.nonessentialStatsbeat, telemetryItemExporter), longIntervalSeconds, longIntervalSeconds, TimeUnit.SECONDS);
        } else {
            logger.debug("Non-essential Statsbeat is disabled.");
        }
    }

    public void shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            logger.debug("Shutting down Statsbeat scheduler.");
            this.scheduledExecutor.shutdown();
            this.azureMetadataService.shutdown();
        }
    }

    public NetworkStatsbeat getNetworkStatsbeat() {
        return this.networkStatsbeat;
    }

    public FeatureStatsbeat getFeatureStatsbeat() {
        return this.featureStatsbeat;
    }

    public FeatureStatsbeat getInstrumentationStatsbeat() {
        return this.instrumentationStatsbeat;
    }

    public NonessentialStatsbeat getNonessentialStatsbeat() {
        return this.nonessentialStatsbeat;
    }

    private void updateConnectionString(StatsbeatConnectionString connectionString) {
        if (connectionString != null) {
            if (RpAttachType.getRpAttachType() != RpAttachType.MANUAL) {
                this.networkStatsbeat.setConnectionString(connectionString);
            }
            this.attachStatsbeat.setConnectionString(connectionString);
            this.featureStatsbeat.setConnectionString(connectionString);
            this.instrumentationStatsbeat.setConnectionString(connectionString);
        }
    }

    private void updateInstrumentationKey(String instrumentationKey) {
        if (instrumentationKey != null && !instrumentationKey.isEmpty()) {
            if (RpAttachType.getRpAttachType() != RpAttachType.MANUAL) {
                this.networkStatsbeat.setInstrumentationKey(instrumentationKey);
            }
            this.attachStatsbeat.setInstrumentationKey(instrumentationKey);
            this.featureStatsbeat.setInstrumentationKey(instrumentationKey);
            this.instrumentationStatsbeat.setInstrumentationKey(instrumentationKey);
        }
    }

    private static class StatsbeatSender
    implements Runnable {
        private final BaseStatsbeat statsbeat;
        private final TelemetryItemExporter telemetryItemExporter;

        private StatsbeatSender(BaseStatsbeat statsbeat, TelemetryItemExporter telemetryItemExporter) {
            this.statsbeat = statsbeat;
            this.telemetryItemExporter = telemetryItemExporter;
        }

        @Override
        public void run() {
            try {
                if (this.statsbeat.getInstrumentationKey() == null || this.statsbeat.getInstrumentationKey().isEmpty()) {
                    return;
                }
                this.statsbeat.send(this.telemetryItemExporter);
            }
            catch (RuntimeException e) {
                try (MDC.MDCCloseable ignored = AzureMonitorMsgId.FAIL_TO_SEND_STATSBEAT_ERROR.makeActive();){
                    logger.error("Error occurred while sending statsbeat", (Throwable)e);
                }
            }
        }
    }
}

