/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInformation {
    private static final Logger logger = LoggerFactory.getLogger(SystemInformation.class);
    private static final String DEFAULT_PROCESS_NAME = "Java_Process";
    private static final boolean WINDOWS;
    private static final boolean LINUX;
    private static final String processId;

    public static String getProcessId() {
        return processId;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    private static String initializeProcessId() {
        int i;
        String rawName = ManagementFactory.getRuntimeMXBean().getName();
        if (!Strings.isNullOrEmpty(rawName) && (i = rawName.indexOf("@")) != -1) {
            String processIdAsString = rawName.substring(0, i);
            try {
                Integer.parseInt(processIdAsString);
                return processIdAsString;
            }
            catch (RuntimeException e) {
                logger.error("Failed to fetch process id: '{}'", (Object)e.toString());
                logger.error("Failed to parse PID as number: '{}'", (Object)e.toString());
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        logger.error("Could not extract PID from runtime name: '" + rawName + "'");
        return DEFAULT_PROCESS_NAME;
    }

    private SystemInformation() {
    }

    static {
        String osName = System.getProperty("os.name");
        String osNameLower = osName == null ? null : osName.toLowerCase(Locale.ROOT);
        WINDOWS = osNameLower != null && osNameLower.startsWith("windows");
        LINUX = osNameLower != null && osNameLower.startsWith("linux");
        processId = SystemInformation.initializeProcessId();
    }
}

