/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import reactor.util.annotation.Nullable;

public class TempDirs {
    private static final List<String> CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES = Collections.unmodifiableList(Arrays.asList("USER", "LOGNAME", "USERNAME"));

    @Nullable
    public static File getApplicationInsightsTempDir(ClientLogger logger, String message) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        tempDir = TempDirs.maybeAddUserSubDir(tempDir);
        if (!(tempDir = new File(tempDir, "applicationinsights")).exists() && !tempDir.mkdirs()) {
            logger.info("Unable to create directory: {}. {}. If this is unexpected, please check that the process has the necessary permissions to create the directory.", new Object[]{tempDir.getAbsolutePath(), message});
            return null;
        }
        if (!tempDir.canRead()) {
            logger.info("Missing read permissions on directory: {}. {}. If this is unexpected, please check that the process has the necessary permissions to read from the directory.", new Object[]{tempDir.getAbsolutePath(), message});
            return null;
        }
        if (!tempDir.canWrite()) {
            logger.info("Missing write permissions on directory: {}. {}. If this is unexpected, please check that the process has the necessary permissions to write to the directory.", new Object[]{tempDir.getAbsolutePath(), message});
            return null;
        }
        return tempDir;
    }

    public static File getSubDir(File parent, String name) {
        File dir = new File(parent, name);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory: " + dir);
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("Missing read permission to subdirectory: " + dir);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Missing write permission to subdirectory: " + dir);
        }
        return dir;
    }

    private static File maybeAddUserSubDir(File dir) {
        String username;
        if ("/tmp".contentEquals(dir.getAbsolutePath()) && (username = TempDirs.determineCurrentUsername()) != null) {
            return new File(dir, username);
        }
        return dir;
    }

    @Nullable
    private static String determineCurrentUsername() {
        String username = System.getProperty("user.name");
        if (!CoreUtils.isNullOrEmpty((CharSequence)username)) {
            return username;
        }
        for (String candidate : CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES) {
            username = System.getenv(candidate);
            if (CoreUtils.isNullOrEmpty((CharSequence)username)) continue;
            return username;
        }
        return null;
    }

    private TempDirs() {
    }
}

