/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadPoolUtils {
    public static ThreadFactory createDaemonThreadFactory(Class<?> clazz, String uniqueId) {
        return ThreadPoolUtils.createNamedDaemonThreadFactory(String.format("%s_%s", clazz.getSimpleName(), uniqueId));
    }

    public static ThreadFactory createDaemonThreadFactory(Class<?> clazz) {
        return ThreadPoolUtils.createNamedDaemonThreadFactory(clazz.getSimpleName());
    }

    public static ThreadFactory createNamedDaemonThreadFactory(final String poolName) {
        return new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(String.format("%s-%d", poolName, this.threadId.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    private ThreadPoolUtils() {
    }
}

