/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import reactor.util.annotation.Nullable;

public class UrlParser {
    @Nullable
    public static String getTarget(String url) {
        int schemeEndIndexExclusive = UrlParser.getSchemeEndIndexExclusive(url);
        if (schemeEndIndexExclusive == -1) {
            return null;
        }
        int hostEndIndexExclusive = UrlParser.getHostEndIndexExclusive(url, schemeEndIndexExclusive);
        if (hostEndIndexExclusive == schemeEndIndexExclusive) {
            return null;
        }
        if (hostEndIndexExclusive < url.length() && url.charAt(hostEndIndexExclusive) != ':') {
            return url.substring(schemeEndIndexExclusive, hostEndIndexExclusive);
        }
        int portStartIndex = hostEndIndexExclusive + 1;
        int portEndIndexExclusive = UrlParser.getPortEndIndexExclusive(url, portStartIndex);
        if (portEndIndexExclusive == portStartIndex) {
            return url.substring(schemeEndIndexExclusive, hostEndIndexExclusive);
        }
        String port = url.substring(portStartIndex, portEndIndexExclusive);
        if (port.equals("80") && url.startsWith("http://") || port.equals("443") && url.startsWith("https://")) {
            return url.substring(schemeEndIndexExclusive, hostEndIndexExclusive);
        }
        return url.substring(schemeEndIndexExclusive, portEndIndexExclusive);
    }

    @Nullable
    public static String getPath(String url) {
        int schemeEndIndexExclusive = UrlParser.getSchemeEndIndexExclusive(url);
        if (schemeEndIndexExclusive == -1) {
            return null;
        }
        int hostEndIndexExclusive = UrlParser.getHostEndIndexExclusive(url, schemeEndIndexExclusive);
        int portEndIndexExclusive = UrlParser.getPortEndIndexExclusive(url, hostEndIndexExclusive);
        int pathEndIndexExclusive = UrlParser.getPathEndIndexExclusive(url, portEndIndexExclusive);
        return url.substring(portEndIndexExclusive, pathEndIndexExclusive);
    }

    @Nullable
    public static String getHost(String url) {
        int hostStartIndex = UrlParser.getSchemeEndIndexExclusive(url);
        if (hostStartIndex == -1) {
            return null;
        }
        int hostEndIndexExclusive = UrlParser.getHostEndIndexExclusive(url, hostStartIndex);
        if (hostEndIndexExclusive == hostStartIndex) {
            return null;
        }
        return url.substring(hostStartIndex, hostEndIndexExclusive);
    }

    @Nullable
    public static Integer getPort(String url) {
        int schemeEndIndexExclusive = UrlParser.getSchemeEndIndexExclusive(url);
        if (schemeEndIndexExclusive == -1) {
            return null;
        }
        int hostEndIndexExclusive = UrlParser.getHostEndIndexExclusive(url, schemeEndIndexExclusive);
        if (hostEndIndexExclusive == schemeEndIndexExclusive) {
            return null;
        }
        if (hostEndIndexExclusive < url.length() && url.charAt(hostEndIndexExclusive) != ':') {
            return null;
        }
        int portStartIndex = hostEndIndexExclusive + 1;
        int portEndIndexExclusive = UrlParser.getPortEndIndexExclusive(url, portStartIndex);
        if (portEndIndexExclusive == portStartIndex) {
            return null;
        }
        return UrlParser.safeParse(url.substring(portStartIndex, portEndIndexExclusive));
    }

    public static int getSchemeEndIndexExclusive(String url) {
        int schemeEndIndex = url.indexOf(58);
        if (schemeEndIndex == -1) {
            return -1;
        }
        int len = url.length();
        if (len <= schemeEndIndex + 2 || url.charAt(schemeEndIndex + 1) != '/' || url.charAt(schemeEndIndex + 2) != '/') {
            return -1;
        }
        return schemeEndIndex + 3;
    }

    public static int getHostEndIndexExclusive(String url, int startIndex) {
        char c;
        int index;
        int len = url.length();
        for (index = startIndex; index < len && (c = url.charAt(index)) != ':' && c != '/' && c != '?' && c != '#'; ++index) {
        }
        return index;
    }

    public static int getPortEndIndexExclusive(String url, int startIndex) {
        char c;
        int index;
        int len = url.length();
        for (index = startIndex; index < len && (c = url.charAt(index)) != '/' && c != '?' && c != '#'; ++index) {
        }
        return index;
    }

    @Nullable
    private static Integer safeParse(String port) {
        try {
            return Integer.valueOf(port);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int getPathEndIndexExclusive(String url, int startIndex) {
        char c;
        int index;
        int len = url.length();
        for (index = startIndex; index < len && (c = url.charAt(index)) != '?' && c != '#'; ++index) {
        }
        return index;
    }

    private UrlParser() {
    }
}

