/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulse;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;

public class LiveMetricsSpanProcessor
implements SpanProcessor {
    private final QuickPulse quickPulse;
    private final SpanDataMapper mapper;

    public LiveMetricsSpanProcessor(QuickPulse quickPulse, SpanDataMapper mapper) {
        this.quickPulse = quickPulse;
        this.mapper = mapper;
    }

    public void onStart(Context context, ReadWriteSpan readWriteSpan) {
    }

    public boolean isStartRequired() {
        return false;
    }

    public void onEnd(ReadableSpan readableSpan) {
        if (this.quickPulse != null && this.quickPulse.isEnabled()) {
            this.quickPulse.add(this.mapper.map(readableSpan.toSpanData()));
        }
    }

    public boolean isEndRequired() {
        return true;
    }
}

