/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.AiSemanticAttributes;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.SemanticAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.function.Function;

public final class RequestChecker {
    private RequestChecker() {
    }

    public static boolean isRequest(SpanData span) {
        return RequestChecker.isRequest(span.getKind(), span.getParentSpanContext(), arg_0 -> ((Attributes)span.getAttributes()).get(arg_0));
    }

    public static boolean isRequest(ReadableSpan span) {
        return RequestChecker.isRequest(span.getKind(), span.getParentSpanContext(), arg_0 -> ((ReadableSpan)span).getAttribute(arg_0));
    }

    public static boolean isRequest(SpanKind kind, SpanContext parentSpanContext, Function<AttributeKey<String>, String> attrFn) {
        if (kind == SpanKind.INTERNAL) {
            return attrFn.apply(AiSemanticAttributes.JOB_SYSTEM) != null && !parentSpanContext.isValid();
        }
        if (kind == SpanKind.CLIENT || kind == SpanKind.PRODUCER) {
            return false;
        }
        if (kind == SpanKind.CONSUMER && "receive".equals(attrFn.apply(SemanticAttributes.MESSAGING_OPERATION))) {
            return false;
        }
        if (kind == SpanKind.SERVER || kind == SpanKind.CONSUMER) {
            return true;
        }
        throw new UnsupportedOperationException(kind.name());
    }
}

