/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.builders;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MetricDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MetricsData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.FormattedTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StatsbeatTelemetryBuilder
extends AbstractTelemetryBuilder {
    private final MetricsData data;

    public static StatsbeatTelemetryBuilder create(String name, double value) {
        StatsbeatTelemetryBuilder telemetryBuilder = new StatsbeatTelemetryBuilder(new MetricsData());
        MetricDataPoint point = new MetricDataPoint();
        point.setName(name);
        point.setValue(value);
        telemetryBuilder.setMetricDataPoint(point);
        telemetryBuilder.setTime(FormattedTime.offSetDateTimeFromNow());
        return telemetryBuilder;
    }

    private StatsbeatTelemetryBuilder(MetricsData data) {
        super(data, "Statsbeat", "MetricData");
        this.data = data;
    }

    public void setMetricDataPoint(MetricDataPoint point) {
        List<MetricDataPoint> metrics = this.data.getMetrics();
        if (metrics == null) {
            metrics = new ArrayList<MetricDataPoint>();
            this.data.setMetrics(metrics);
        }
        if (metrics.isEmpty()) {
            metrics.add(point);
        }
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

