/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.ConnectionStringBuilder;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class ConnectionString {
    private static final Map<String, ConnectionString> cache = new ConcurrentHashMap<String, ConnectionString>();
    private final String instrumentationKey;
    private final String ingestionEndpoint;
    private final URL liveEndpoint;
    private final URL profilerEndpoint;
    private final String originalString;
    private final String aadAudience;

    ConnectionString(String instrumentationKey, URL ingestionEndpoint, URL liveEndpoint, URL profilerEndpoint, String originalString, String aadAudience) {
        this.instrumentationKey = instrumentationKey;
        this.ingestionEndpoint = ingestionEndpoint.toExternalForm();
        this.liveEndpoint = liveEndpoint;
        this.profilerEndpoint = profilerEndpoint;
        this.originalString = originalString;
        this.aadAudience = aadAudience;
    }

    public static ConnectionString parse(String connectionString) {
        Objects.requireNonNull(connectionString, "Connection string cannot be null");
        return cache.computeIfAbsent(connectionString, key -> new ConnectionStringBuilder().setConnectionString((String)key).build());
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public String getIngestionEndpoint() {
        return this.ingestionEndpoint;
    }

    public URL getLiveEndpoint() {
        return this.liveEndpoint;
    }

    public URL getProfilerEndpoint() {
        return this.profilerEndpoint;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public String getAadAudienceWithScope() {
        return this.aadAudience + "/.default";
    }
}

