/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration;

import com.azure.core.util.CoreUtils;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.DefaultEndpoints;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

class ConnectionStringBuilder {
    static final int CONNECTION_STRING_MAX_LENGTH = 4096;
    static final String DEFAULT_AAD_AUDIENCE = "https://monitor.azure.com/";
    private String originalString;
    private String instrumentationKey;
    private URL ingestionEndpoint;
    private URL liveEndpoint;
    private URL profilerEndpoint;
    private String aadAudience;

    ConnectionStringBuilder() {
        try {
            this.ingestionEndpoint = new URL(DefaultEndpoints.INGESTION_ENDPOINT);
            this.liveEndpoint = new URL("https://rt.services.visualstudio.com/");
            this.profilerEndpoint = new URL("https://agent.azureserviceprofiler.net/");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("ConnectionString.Defaults are invalid", e);
        }
        this.aadAudience = DEFAULT_AAD_AUDIENCE;
    }

    ConnectionStringBuilder setConnectionString(String connectionString) {
        this.originalString = connectionString;
        this.mapToConnectionConfiguration(ConnectionStringBuilder.getKeyValuePairs(connectionString));
        return this;
    }

    ConnectionString build() {
        return new ConnectionString(this.instrumentationKey, this.ingestionEndpoint, this.liveEndpoint, this.profilerEndpoint, this.originalString, this.aadAudience);
    }

    private static Map<String, String> getKeyValuePairs(String connectionString) {
        TreeMap<String, String> kvps;
        if (connectionString.length() > 4096) {
            throw new IllegalArgumentException("ConnectionString values with more than 4096 characters are not allowed.");
        }
        try {
            kvps = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            kvps.putAll(ConnectionStringBuilder.extractKeyValuesFromConnectionString(connectionString));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not parse connection string.", e);
        }
        return kvps;
    }

    private static Map<String, String> extractKeyValuesFromConnectionString(String connectionString) {
        String[] splits;
        Objects.requireNonNull(connectionString);
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (String split : splits = connectionString.split(";")) {
            String[] keyValPair = split.split("=");
            if (keyValPair.length != 2) continue;
            keyValues.put(keyValPair[0], keyValPair[1]);
        }
        return keyValues;
    }

    private void mapToConnectionConfiguration(Map<String, String> kvps) {
        String profilerEndpoint;
        String ingestionEndpoint;
        String liveEndpoint;
        String aadAudience;
        this.instrumentationKey = kvps.get("InstrumentationKey");
        if (CoreUtils.isNullOrEmpty((CharSequence)this.instrumentationKey)) {
            throw new IllegalArgumentException("Missing 'InstrumentationKey'");
        }
        String suffix = kvps.get("EndpointSuffix");
        if (!CoreUtils.isNullOrEmpty((CharSequence)suffix)) {
            if (suffix.startsWith(".")) {
                suffix = suffix.substring(1);
            }
            this.setIngestionEndpoint("https://dc." + suffix);
            this.setLiveEndpoint("https://live." + suffix);
            this.setProfilerEndpoint("https://profiler." + suffix);
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(aadAudience = kvps.get("AADAudience")))) {
            this.setAadAudience(aadAudience);
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(liveEndpoint = kvps.get("LiveEndpoint")))) {
            this.setLiveEndpoint(liveEndpoint);
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(ingestionEndpoint = kvps.get("IngestionEndpoint")))) {
            this.setIngestionEndpoint(ingestionEndpoint);
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(profilerEndpoint = kvps.get("ProfilerEndpoint")))) {
            this.setProfilerEndpoint(profilerEndpoint);
        }
    }

    void setIngestionEndpoint(String ingestionEndpoint) {
        this.ingestionEndpoint = ConnectionStringBuilder.toUrlOrThrow(ingestionEndpoint, "IngestionEndpoint");
    }

    void setLiveEndpoint(String liveEndpoint) {
        this.liveEndpoint = ConnectionStringBuilder.toUrlOrThrow(liveEndpoint, "LiveEndpoint");
    }

    void setProfilerEndpoint(String profilerEndpoint) {
        this.profilerEndpoint = ConnectionStringBuilder.toUrlOrThrow(profilerEndpoint, "ProfilerEndpoint");
    }

    void setAadAudience(String aadAudience) {
        this.aadAudience = aadAudience;
    }

    private static URL toUrlOrThrow(String url, String field) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            URL result = new URL(url);
            String scheme = result.getProtocol();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException(field + " of the connection string must specify supported protocol, either 'http' or 'https': \"" + url + "\"");
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(field + " is invalid: \"" + url + "\"", e);
        }
    }

    static class Keywords {
        static final String INSTRUMENTATION_KEY = "InstrumentationKey";
        static final String ENDPOINT_SUFFIX = "EndpointSuffix";
        static final String INGESTION_ENDPOINT = "IngestionEndpoint";
        static final String LIVE_ENDPOINT = "LiveEndpoint";
        static final String PROFILER_ENDPOINT = "ProfilerEndpoint";
        static final String AAD_AUDIENCE = "AADAudience";

        private Keywords() {
        }
    }

    static class EndpointPrefixes {
        static final String INGESTION_ENDPOINT_PREFIX = "dc";
        static final String LIVE_ENDPOINT_PREFIX = "live";
        static final String PROFILER_ENDPOINT_PREFIX = "profiler";

        private EndpointPrefixes() {
        }
    }
}

