/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat.HeartBeatPayloadProviderInterface;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.heartbeat.HeartbeatExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.VersionGenerator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHeartBeatPropertyProvider
implements HeartBeatPayloadProviderInterface {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHeartBeatPropertyProvider.class);
    final Set<String> defaultFields = new HashSet<String>();
    private static volatile UUID uniqueProcessId;
    private static final String JRE_VERSION = "jreVersion";
    private static final String SDK_VERSION = "sdkVersion";
    private static final String OS_VERSION = "osVersion";
    private static final String PROCESS_SESSION_ID = "processSessionId";
    private static final String OS_TYPE = "osType";

    public DefaultHeartBeatPropertyProvider() {
        DefaultHeartBeatPropertyProvider.initializeDefaultFields(this.defaultFields);
    }

    @Override
    public Runnable setDefaultPayload(final HeartbeatExporter provider) {
        return new Runnable(){
            final Set<String> enabledProperties;
            {
                this.enabledProperties = DefaultHeartBeatPropertyProvider.this.defaultFields;
            }

            @Override
            public void run() {
                for (String fieldName : this.enabledProperties) {
                    try {
                        switch (fieldName) {
                            case "jreVersion": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.getJreVersion(), true);
                                break;
                            }
                            case "sdkVersion": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.getSdkVersion(), true);
                                break;
                            }
                            case "osVersion": 
                            case "osType": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.getOsVersion(), true);
                                break;
                            }
                            case "processSessionId": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.getProcessSessionId(), true);
                                break;
                            }
                            default: {
                                logger.trace("Encountered unknown default property");
                                break;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn("Failed to obtain heartbeat property", (Throwable)e);
                    }
                }
            }
        };
    }

    private static void initializeDefaultFields(Set<String> defaultFields) {
        defaultFields.add(JRE_VERSION);
        defaultFields.add(SDK_VERSION);
        defaultFields.add(OS_VERSION);
        defaultFields.add(PROCESS_SESSION_ID);
        defaultFields.add(OS_TYPE);
    }

    private static String getJreVersion() {
        return System.getProperty("java.version");
    }

    private static String getSdkVersion() {
        return VersionGenerator.getSdkVersion();
    }

    private static String getOsVersion() {
        return System.getProperty("os.name");
    }

    private static String getProcessSessionId() {
        if (uniqueProcessId == null) {
            uniqueProcessId = UUID.randomUUID();
        }
        return uniqueProcessId.toString();
    }
}

