/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.localstorage;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class FileUtil {
    static List<File> listTrnFiles(File directory) {
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".trn"));
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    static String getBaseName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, index);
    }

    static void moveFile(File srcFile, File destFile) throws IOException {
        if (!srcFile.renameTo(destFile)) {
            throw new IOException("Unable to rename file '" + srcFile.getAbsolutePath() + "' to '" + destFile.getAbsolutePath() + "'");
        }
    }

    static boolean deleteFileWithRetries(File file) {
        if (!file.delete()) {
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                if (file.delete()) break;
            }
        }
        return true;
    }

    private FileUtil() {
    }
}

