/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.localstorage;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.localstorage.LocalFileLoader;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryPipelineResponse;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.StatusCode;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.File;

class LocalFileSenderTelemetryPipelineListener
implements TelemetryPipelineListener {
    private final LocalFileLoader localFileLoader;
    private final File file;

    LocalFileSenderTelemetryPipelineListener(LocalFileLoader localFileLoader, File file) {
        this.localFileLoader = localFileLoader;
        this.file = file;
    }

    @Override
    public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        int responseCode = response.getStatusCode();
        if (responseCode == 200) {
            this.localFileLoader.updateProcessedFileStatus(true, this.file);
        } else {
            this.localFileLoader.updateProcessedFileStatus(!StatusCode.isRetryable(responseCode), this.file);
        }
    }

    @Override
    public void onException(TelemetryPipelineRequest request, String errorMessage, Throwable throwable) {
        this.localFileLoader.updateProcessedFileStatus(false, this.file);
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

