/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.logging;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.ThreadPoolUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

class AggregatingLogger {
    static final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(AggregatingLogger.class, "aggregating logger"));
    private final Logger logger;
    private final String grouping;
    private final int intervalSeconds;
    private final boolean trackingOperations;
    private final AtomicBoolean firstFailure = new AtomicBoolean();
    private long numSuccesses;
    private Map<String, MutableLong> failureMessages = new HashMap<String, MutableLong>();
    private final Object lock = new Object();

    AggregatingLogger(Class<?> source, String operation, boolean trackingOperations) {
        this(source, operation, trackingOperations, 300);
    }

    AggregatingLogger(Class<?> source, String operation, boolean trackingOperations, int intervalSeconds) {
        this.logger = LoggerFactory.getLogger(source);
        this.grouping = operation;
        this.trackingOperations = trackingOperations;
        this.intervalSeconds = intervalSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordSuccess() {
        Object object = this.lock;
        synchronized (object) {
            ++this.numSuccesses;
        }
    }

    void recordWarning(String warningMessage) {
        this.recordWarning(warningMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordWarning(String warningMessage, @Nullable Throwable exception) {
        if (!this.firstFailure.getAndSet(true)) {
            this.logger.warn("{}: {} (future warnings will be aggregated and logged once every {} minutes)", new Object[]{this.grouping, warningMessage, this.intervalSeconds / 60, exception});
            scheduledExecutor.scheduleWithFixedDelay(new ExceptionStatsLogger(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
            return;
        }
        this.logger.debug("{} {}", new Object[]{this.grouping, warningMessage, exception});
        Object object = this.lock;
        synchronized (object) {
            if (this.failureMessages.size() < 10) {
                this.failureMessages.computeIfAbsent(warningMessage, key -> new MutableLong()).increment();
            } else {
                MutableLong count = this.failureMessages.get(warningMessage);
                if (count != null) {
                    count.increment();
                } else {
                    this.failureMessages.computeIfAbsent("other", key -> new MutableLong()).increment();
                }
            }
        }
    }

    private static long getTotalFailures(Map<String, MutableLong> failureMessages) {
        long total = 0L;
        for (MutableLong value : failureMessages.values()) {
            total += value.value;
        }
        return total;
    }

    private class ExceptionStatsLogger
    implements Runnable {
        private ExceptionStatsLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map failureMessages;
            long numSuccesses;
            Object object = AggregatingLogger.this.lock;
            synchronized (object) {
                numSuccesses = AggregatingLogger.this.numSuccesses;
                failureMessages = AggregatingLogger.this.failureMessages;
                AggregatingLogger.this.numSuccesses = 0L;
                AggregatingLogger.this.failureMessages = new HashMap();
            }
            if (!failureMessages.isEmpty()) {
                long numWarnings = AggregatingLogger.getTotalFailures(failureMessages);
                long numMinutes = AggregatingLogger.this.intervalSeconds / 60;
                long total = numSuccesses + numWarnings;
                StringBuilder message = new StringBuilder();
                message.append("In the last ");
                message.append(numMinutes);
                message.append(" minutes, the following");
                if (AggregatingLogger.this.trackingOperations) {
                    message.append(" operation has failed ");
                    message.append(numWarnings);
                    message.append(" times (out of ");
                    message.append(total);
                    message.append("): ");
                } else {
                    message.append(" warning has occurred ");
                    message.append(numWarnings);
                    message.append(" times: ");
                }
                message.append(AggregatingLogger.this.grouping);
                message.append(":");
                failureMessages.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(entry -> {
                    message.append(System.lineSeparator());
                    message.append(" * ");
                    message.append((String)entry.getKey());
                    message.append(" (");
                    message.append(((MutableLong)entry.getValue()).value);
                    message.append(" times)");
                });
                AggregatingLogger.this.logger.warn(message.toString());
            }
        }
    }

    private static class MutableLong
    implements Comparable<MutableLong> {
        private long value;

        private MutableLong() {
        }

        private void increment() {
            ++this.value;
        }

        @Override
        public int compareTo(MutableLong other) {
            return Long.compare(this.value, other.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MutableLong)) {
                return false;
            }
            MutableLong that = (MutableLong)obj;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

