/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryErrorDetails;
import java.io.IOException;
import java.util.List;

public final class ExportResult
implements JsonSerializable<ExportResult> {
    private Integer itemsReceived;
    private Integer itemsAccepted;
    private List<TelemetryErrorDetails> errors;

    public Integer getItemsReceived() {
        return this.itemsReceived;
    }

    public ExportResult setItemsReceived(Integer itemsReceived) {
        this.itemsReceived = itemsReceived;
        return this;
    }

    public Integer getItemsAccepted() {
        return this.itemsAccepted;
    }

    public ExportResult setItemsAccepted(Integer itemsAccepted) {
        this.itemsAccepted = itemsAccepted;
        return this;
    }

    public List<TelemetryErrorDetails> getErrors() {
        return this.errors;
    }

    public ExportResult setErrors(List<TelemetryErrorDetails> errors) {
        this.errors = errors;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("itemsReceived", (Number)this.itemsReceived);
        jsonWriter.writeNumberField("itemsAccepted", (Number)this.itemsAccepted);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExportResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExportResult)jsonReader.readObject(reader -> {
            ExportResult deserializedExportResult = new ExportResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("itemsReceived".equals(fieldName)) {
                    deserializedExportResult.itemsReceived = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("itemsAccepted".equals(fieldName)) {
                    deserializedExportResult.itemsAccepted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedExportResult.errors = errors = reader.readArray(reader1 -> TelemetryErrorDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportResult;
        });
    }
}

