/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.DataPointType;
import java.io.IOException;

public final class MetricDataPoint
implements JsonSerializable<MetricDataPoint> {
    private String namespace;
    private String name;
    private DataPointType dataPointType;
    private double value;
    private Integer count;
    private Double min;
    private Double max;
    private Double stdDev;

    public String getNamespace() {
        return this.namespace;
    }

    public MetricDataPoint setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MetricDataPoint setName(String name) {
        this.name = name;
        return this;
    }

    public DataPointType getDataPointType() {
        return this.dataPointType;
    }

    public MetricDataPoint setDataPointType(DataPointType dataPointType) {
        this.dataPointType = dataPointType;
        return this;
    }

    public double getValue() {
        return this.value;
    }

    public MetricDataPoint setValue(double value) {
        this.value = value;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public MetricDataPoint setCount(Integer count) {
        this.count = count;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public MetricDataPoint setMin(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public MetricDataPoint setMax(Double max) {
        this.max = max;
        return this;
    }

    public Double getStdDev() {
        return this.stdDev;
    }

    public MetricDataPoint setStdDev(Double stdDev) {
        this.stdDev = stdDev;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeDoubleField("value", this.value);
        jsonWriter.writeStringField("ns", this.namespace);
        jsonWriter.writeStringField("kind", this.dataPointType == null ? null : this.dataPointType.toString());
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeNumberField("min", (Number)this.min);
        jsonWriter.writeNumberField("max", (Number)this.max);
        jsonWriter.writeNumberField("stdDev", (Number)this.stdDev);
        return jsonWriter.writeEndObject();
    }

    public static MetricDataPoint fromJson(JsonReader jsonReader) throws IOException {
        return (MetricDataPoint)jsonReader.readObject(reader -> {
            MetricDataPoint deserializedMetricDataPoint = new MetricDataPoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricDataPoint.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedMetricDataPoint.value = reader.getDouble();
                    continue;
                }
                if ("ns".equals(fieldName)) {
                    deserializedMetricDataPoint.namespace = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedMetricDataPoint.dataPointType = DataPointType.fromString(reader.getString());
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedMetricDataPoint.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("min".equals(fieldName)) {
                    deserializedMetricDataPoint.min = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max".equals(fieldName)) {
                    deserializedMetricDataPoint.max = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("stdDev".equals(fieldName)) {
                    deserializedMetricDataPoint.stdDev = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricDataPoint;
        });
    }
}

