/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorDomain;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TelemetryEventData
extends MonitorDomain {
    private String name;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public String getName() {
        return this.name;
    }

    public TelemetryEventData setName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TelemetryEventData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public TelemetryEventData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public TelemetryEventData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("measurements", this.measurements, (writer, element) -> writer.writeDouble(element.doubleValue()));
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TelemetryEventData fromJson(JsonReader jsonReader) throws IOException {
        return (TelemetryEventData)jsonReader.readObject(reader -> {
            TelemetryEventData deserializedTelemetryEventData = new TelemetryEventData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedTelemetryEventData.setVersion(reader.getInt());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTelemetryEventData.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedTelemetryEventData.properties = properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    Map measurements;
                    deserializedTelemetryEventData.measurements = measurements = reader.readMap(reader1 -> reader1.getDouble());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTelemetryEventData.setAdditionalProperties(additionalProperties);
            return deserializedTelemetryEventData;
        });
    }
}

