/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorBase;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TelemetryItem
implements JsonSerializable<TelemetryItem> {
    private Integer version;
    private String name;
    private OffsetDateTime time;
    private Float sampleRate;
    private String sequence;
    private String instrumentationKey;
    private Map<String, String> tags;
    private MonitorBase data;
    private String connectionString;
    private Resource resource;

    public Integer getVersion() {
        return this.version;
    }

    public TelemetryItem setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TelemetryItem setName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public TelemetryItem setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public Float getSampleRate() {
        return this.sampleRate;
    }

    public TelemetryItem setSampleRate(Float sampleRate) {
        this.sampleRate = sampleRate;
        return this;
    }

    public String getSequence() {
        return this.sequence;
    }

    public TelemetryItem setSequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public TelemetryItem setInstrumentationKey(String instrumentationKey) {
        this.instrumentationKey = instrumentationKey;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public TelemetryItem setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public MonitorBase getData() {
        return this.data;
    }

    public TelemetryItem setData(MonitorBase data) {
        this.data = data;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("ver", (Number)this.version);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeNumberField("sampleRate", (Number)this.sampleRate);
        jsonWriter.writeStringField("seq", this.sequence);
        jsonWriter.writeStringField("iKey", this.instrumentationKey);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("data", (JsonSerializable)this.data);
        return jsonWriter.writeEndObject();
    }

    public static TelemetryItem fromJson(JsonReader jsonReader) throws IOException {
        return (TelemetryItem)jsonReader.readObject(reader -> {
            TelemetryItem deserializedTelemetryItem = new TelemetryItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTelemetryItem.name = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedTelemetryItem.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("ver".equals(fieldName)) {
                    deserializedTelemetryItem.version = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sampleRate".equals(fieldName)) {
                    deserializedTelemetryItem.sampleRate = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("seq".equals(fieldName)) {
                    deserializedTelemetryItem.sequence = reader.getString();
                    continue;
                }
                if ("iKey".equals(fieldName)) {
                    deserializedTelemetryItem.instrumentationKey = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTelemetryItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedTelemetryItem.data = MonitorBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTelemetryItem;
        });
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public TelemetryItem setConnectionString(String connectionString) {
        this.connectionString = connectionString;
        this.instrumentationKey = ConnectionString.parse(connectionString).getInstrumentationKey();
        return this;
    }

    public TelemetryItem setConnectionString(ConnectionString connectionString) {
        this.connectionString = connectionString.getOriginalString();
        this.instrumentationKey = connectionString.getInstrumentationKey();
        return this;
    }

    public TelemetryItem setConnectionString(StatsbeatConnectionString connectionString) {
        this.instrumentationKey = connectionString.getInstrumentationKey();
        this.connectionString = "InstrumentationKey=" + this.instrumentationKey + ";IngestionEndpoint=" + connectionString.getIngestionEndpoint();
        return this;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Map<String, String> getResourceFromTags() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resourceFromTags = new HashMap<String, String>();
        this.populateFromTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), resourceFromTags);
        this.populateFromTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), resourceFromTags);
        this.populateFromTag(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString(), resourceFromTags);
        return resourceFromTags;
    }

    private void populateFromTag(String contextTagKey, Map<String, String> resourceFromTags) {
        if (this.tags == null) {
            return;
        }
        String roleName = this.tags.get(contextTagKey);
        if (roleName != null) {
            resourceFromTags.put(contextTagKey, roleName);
        }
    }
}

