/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class AppInsightsByteBufferPool {
    private static final int BYTE_BUFFER_SIZE = 65536;
    private static final int MAX_RETAINED = 10;
    private final Queue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(10);

    ByteBuffer remove() {
        ByteBuffer byteBuffer = this.queue.poll();
        if (byteBuffer != null) {
            byteBuffer.clear();
            return byteBuffer;
        }
        return ByteBuffer.allocate(65536);
    }

    void offer(List<ByteBuffer> byteBuffers) {
        for (ByteBuffer byteBuffer : byteBuffers) {
            this.queue.offer(byteBuffer);
        }
    }
}

