/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MessageData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.MonitorDomain;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.RemoteDependencyData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.RequestData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryExceptionData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryExceptionDetails;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.QuickPulseStatus;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.DependencyDataColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.DerivedMetricProjections;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.ExceptionDataColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.Filter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.FilteringConfiguration;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.RequestDataColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TraceDataColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.AggregationType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationError;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DerivedMetricInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Exception;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterConjunctionGroupInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.RemoteDependency;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Request;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.TelemetryType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Trace;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.CpuPerformanceCounterCalculator;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

final class QuickPulseDataCollector {
    private static final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean operatingSystemMxBean = ManagementFactory.getOperatingSystemMXBean();
    private final AtomicReference<Counters> counters = new AtomicReference<Object>(null);
    private final CpuPerformanceCounterCalculator cpuPerformanceCounterCalculator = QuickPulseDataCollector.getCpuPerformanceCounterCalculator();
    private volatile QuickPulseStatus quickPulseStatus = QuickPulseStatus.QP_IS_OFF;
    private volatile Supplier<String> instrumentationKeySupplier;
    private final AtomicReference<FilteringConfiguration> configuration;

    QuickPulseDataCollector(AtomicReference<FilteringConfiguration> configuration) {
        this.configuration = configuration;
    }

    private static CpuPerformanceCounterCalculator getCpuPerformanceCounterCalculator() {
        return new CpuPerformanceCounterCalculator();
    }

    synchronized void disable() {
        this.counters.set(null);
        this.quickPulseStatus = QuickPulseStatus.QP_IS_OFF;
    }

    synchronized void enable(Supplier<String> instrumentationKeySupplier) {
        this.instrumentationKeySupplier = instrumentationKeySupplier;
        FilteringConfiguration config = this.configuration.get();
        this.counters.set(new Counters(config.getValidProjectionInitInfo(), config.getErrors()));
    }

    synchronized void setQuickPulseStatus(QuickPulseStatus quickPulseStatus) {
        this.quickPulseStatus = quickPulseStatus;
    }

    synchronized QuickPulseStatus getQuickPulseStatus() {
        return this.quickPulseStatus;
    }

    @Nullable
    synchronized FinalCounters getAndRestart() {
        FilteringConfiguration config = this.configuration.get();
        Counters currentCounters = this.counters.getAndSet(new Counters(config.getValidProjectionInitInfo(), config.getErrors()));
        if (currentCounters != null) {
            return new FinalCounters(currentCounters);
        }
        return null;
    }

    @Nullable
    synchronized FinalCounters peek() {
        Counters currentCounters = this.counters.get();
        if (currentCounters != null) {
            return new FinalCounters(currentCounters);
        }
        return null;
    }

    void add(TelemetryItem telemetryItem) {
        if (!this.isEnabled()) {
            return;
        }
        if (!telemetryItem.getInstrumentationKey().equals(this.instrumentationKeySupplier.get())) {
            return;
        }
        Float sampleRate = telemetryItem.getSampleRate();
        if (sampleRate != null && sampleRate.floatValue() == 0.0f) {
            return;
        }
        int itemCount = sampleRate == null ? 1 : Math.round(100.0f / sampleRate.floatValue());
        FilteringConfiguration currentConfig = this.configuration.get();
        MonitorDomain data = telemetryItem.getData().getBaseData();
        if (data instanceof RequestData) {
            RequestData requestTelemetry = (RequestData)data;
            this.addRequest(requestTelemetry, itemCount, QuickPulseDataCollector.getOperationName(telemetryItem), currentConfig);
        } else if (data instanceof RemoteDependencyData) {
            this.addDependency((RemoteDependencyData)data, itemCount, currentConfig);
        } else if (data instanceof TelemetryExceptionData) {
            this.addException((TelemetryExceptionData)data, itemCount, currentConfig);
        } else if (data instanceof MessageData) {
            this.addTrace((MessageData)data, currentConfig);
        }
    }

    boolean isEnabled() {
        return this.quickPulseStatus == QuickPulseStatus.QP_IS_ON;
    }

    @Nullable
    private static String getOperationName(TelemetryItem telemetryItem) {
        Map<String, String> tags = telemetryItem.getTags();
        return tags == null ? null : tags.get(ContextTagKeys.AI_OPERATION_NAME.toString());
    }

    private boolean matchesDocumentFilters(TelemetryColumns columns, TelemetryType telemetryType, FilteringConfiguration currentConfig, List<String> matchingDocumentStreamIds) {
        Map<String, List<FilterConjunctionGroupInfo>> documentsConfig = currentConfig.fetchDocumentsConfigForTelemetryType(telemetryType);
        if (documentsConfig.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, List<FilterConjunctionGroupInfo>> entry : documentsConfig.entrySet()) {
            String documentStreamId = entry.getKey();
            for (FilterConjunctionGroupInfo filterGroup : entry.getValue()) {
                if (!Filter.checkFilterConjunctionGroup(filterGroup, columns) || matchingDocumentStreamIds.contains(documentStreamId)) continue;
                matchingDocumentStreamIds.add(documentStreamId);
            }
        }
        return !matchingDocumentStreamIds.isEmpty();
    }

    private void applyMetricFilters(TelemetryColumns columns, TelemetryType telemetryType, FilteringConfiguration currentConfig, Counters currentCounters) {
        List<DerivedMetricInfo> metricsConfig = currentConfig.fetchMetricConfigForTelemetryType(telemetryType);
        for (DerivedMetricInfo derivedMetricInfo : metricsConfig) {
            if (!Filter.checkMetricFilters(derivedMetricInfo, columns)) continue;
            currentCounters.derivedMetrics.calculateProjection(derivedMetricInfo, columns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependency(RemoteDependencyData telemetry, int itemCount, FilteringConfiguration currentConfig) {
        Counters counters = this.counters.get();
        if (counters == null) {
            return;
        }
        long durationMillis = QuickPulseDataCollector.parseDurationToMillis(telemetry.getDuration());
        counters.rddsAndDuations.addAndGet(Counters.encodeCountAndDuration(itemCount, durationMillis));
        Boolean success = telemetry.isSuccess();
        if (success != null && !success.booleanValue()) {
            counters.unsuccessfulRdds.incrementAndGet();
        }
        DependencyDataColumns columns = new DependencyDataColumns(telemetry);
        this.applyMetricFilters(columns, TelemetryType.DEPENDENCY, currentConfig, counters);
        ArrayList<String> documentStreamIds = new ArrayList<String>();
        if (this.matchesDocumentFilters(columns, TelemetryType.DEPENDENCY, currentConfig, documentStreamIds)) {
            RemoteDependency dependencyDoc = new RemoteDependency();
            dependencyDoc.setName(telemetry.getName());
            dependencyDoc.setCommandName(telemetry.getData());
            dependencyDoc.setDuration(Duration.ofMillis(durationMillis).toString());
            dependencyDoc.setResultCode(telemetry.getResultCode());
            dependencyDoc.setProperties((List)QuickPulseDataCollector.setCustomDimensions(telemetry.getProperties(), telemetry.getMeasurements()));
            dependencyDoc.setDocumentStreamIds(documentStreamIds);
            List<DocumentIngress> list = counters.documentList;
            synchronized (list) {
                if (counters.documentList.size() < 1000) {
                    counters.documentList.add(dependencyDoc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addException(TelemetryExceptionData exceptionData, int itemCount, FilteringConfiguration currentConfig) {
        Counters counters = this.counters.get();
        if (counters == null) {
            return;
        }
        counters.exceptions.addAndGet(itemCount);
        ExceptionDataColumns columns = new ExceptionDataColumns(exceptionData);
        this.applyMetricFilters(columns, TelemetryType.EXCEPTION, currentConfig, counters);
        ArrayList<String> documentStreamIds = new ArrayList<String>();
        if (this.matchesDocumentFilters(columns, TelemetryType.EXCEPTION, currentConfig, documentStreamIds)) {
            List<TelemetryExceptionDetails> exceptionList = exceptionData.getExceptions();
            Exception exceptionDoc = new Exception();
            if (exceptionList != null && !exceptionList.isEmpty()) {
                exceptionDoc.setExceptionMessage(exceptionList.get(0).getMessage());
                exceptionDoc.setExceptionType(exceptionList.get(0).getTypeName());
            }
            exceptionDoc.setProperties((List)QuickPulseDataCollector.setCustomDimensions(exceptionData.getProperties(), exceptionData.getMeasurements()));
            exceptionDoc.setDocumentStreamIds(documentStreamIds);
            List<DocumentIngress> list = counters.documentList;
            synchronized (list) {
                if (counters.documentList.size() < 1000) {
                    counters.documentList.add(exceptionDoc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(RequestData requestTelemetry, int itemCount, String operationName, FilteringConfiguration currentConfig) {
        Counters counters = this.counters.get();
        if (counters == null) {
            return;
        }
        long durationMillis = QuickPulseDataCollector.parseDurationToMillis(requestTelemetry.getDuration());
        counters.requestsAndDurations.addAndGet(Counters.encodeCountAndDuration(itemCount, durationMillis));
        if (!requestTelemetry.isSuccess()) {
            counters.unsuccessfulRequests.incrementAndGet();
        }
        RequestDataColumns columns = new RequestDataColumns(requestTelemetry);
        this.applyMetricFilters(columns, TelemetryType.REQUEST, currentConfig, counters);
        ArrayList<String> documentStreamIds = new ArrayList<String>();
        if (this.matchesDocumentFilters(columns, TelemetryType.REQUEST, currentConfig, documentStreamIds)) {
            Request requestDoc = new Request();
            requestDoc.setDuration(Duration.ofMillis(durationMillis).toString());
            requestDoc.setResponseCode(requestTelemetry.getResponseCode());
            requestDoc.setName(requestTelemetry.getName());
            requestDoc.setUrl(requestTelemetry.getUrl());
            requestDoc.setProperties((List)QuickPulseDataCollector.setCustomDimensions(requestTelemetry.getProperties(), requestTelemetry.getMeasurements()));
            requestDoc.setDocumentStreamIds(documentStreamIds);
            List<DocumentIngress> list = counters.documentList;
            synchronized (list) {
                if (counters.documentList.size() < 1000) {
                    counters.documentList.add(requestDoc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrace(MessageData traceTelemetry, FilteringConfiguration currentConfig) {
        Counters counters = this.counters.get();
        TraceDataColumns columns = new TraceDataColumns(traceTelemetry);
        this.applyMetricFilters(columns, TelemetryType.TRACE, currentConfig, counters);
        ArrayList<String> documentStreamIds = new ArrayList<String>();
        if (this.matchesDocumentFilters(columns, TelemetryType.TRACE, currentConfig, documentStreamIds)) {
            Trace traceDoc = new Trace();
            traceDoc.setMessage(traceTelemetry.getMessage());
            traceDoc.setProperties((List)QuickPulseDataCollector.setCustomDimensions(traceTelemetry.getProperties(), traceTelemetry.getMeasurements()));
            traceDoc.setDocumentStreamIds(documentStreamIds);
            List<DocumentIngress> list = counters.documentList;
            synchronized (list) {
                if (counters.documentList.size() < 1000) {
                    counters.documentList.add(traceDoc);
                }
            }
        }
    }

    private static List<KeyValuePairString> setCustomDimensions(@Nullable Map<String, String> properties, @Nullable Map<String, Double> measurements) {
        KeyValuePairString kvPair;
        ArrayList<KeyValuePairString> customDims = new ArrayList<KeyValuePairString>();
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                kvPair = new KeyValuePairString();
                kvPair.setKey(entry.getKey());
                kvPair.setValue((String)entry.getValue());
                customDims.add(kvPair);
            }
        }
        if (measurements != null) {
            for (Map.Entry<String, Object> entry : measurements.entrySet()) {
                kvPair = new KeyValuePairString();
                kvPair.setKey(entry.getKey());
                kvPair.setValue(((Double)entry.getValue()).toString());
                customDims.add(kvPair);
            }
        }
        return customDims;
    }

    static long parseDurationToMillis(String duration) {
        return QuickPulseDataCollector.startingAtDaysOrHours(duration);
    }

    private static long startingAtDaysOrHours(String duration) {
        int i = 0;
        char c = duration.charAt(i++);
        long daysOrHours = QuickPulseDataCollector.charToInt(c);
        c = duration.charAt(i++);
        while (c != ':' && c != '.') {
            daysOrHours = 10L * daysOrHours + (long)QuickPulseDataCollector.charToInt(c);
            c = duration.charAt(i++);
        }
        if (c == ':') {
            return QuickPulseDataCollector.startingAtMinutes(duration, i, daysOrHours);
        }
        return QuickPulseDataCollector.startingAtHours(duration, i, daysOrHours);
    }

    private static long startingAtHours(String duration, int i, long runningTotalInDays) {
        char c1 = duration.charAt(i++);
        char c2 = duration.charAt(i++);
        int hours = 10 * QuickPulseDataCollector.charToInt(c1) + QuickPulseDataCollector.charToInt(c2);
        return QuickPulseDataCollector.startingAtMinutes(duration, i + 1, 24L * runningTotalInDays + (long)hours);
    }

    private static long startingAtMinutes(String duration, int i, long runningTotalInHours) {
        char c1 = duration.charAt(i++);
        char c2 = duration.charAt(i++);
        int minutes = 10 * QuickPulseDataCollector.charToInt(c1) + QuickPulseDataCollector.charToInt(c2);
        return QuickPulseDataCollector.startingAtSeconds(duration, i + 1, 60L * runningTotalInHours + (long)minutes);
    }

    private static long startingAtSeconds(String duration, int i, long runningTotalInMinutes) {
        char c1 = duration.charAt(i++);
        char c2 = duration.charAt(i++);
        int seconds = 10 * QuickPulseDataCollector.charToInt(c1) + QuickPulseDataCollector.charToInt(c2);
        return QuickPulseDataCollector.startingAtMicros(duration, i + 1, 60L * runningTotalInMinutes + (long)seconds);
    }

    private static long startingAtMicros(String duration, int i, long runningTotalInSeconds) {
        int millis = 0;
        for (int j = i; j < i + 3; ++j) {
            char c = duration.charAt(j);
            millis = 10 * millis + QuickPulseDataCollector.charToInt(c);
        }
        return 1000L * runningTotalInSeconds + (long)millis;
    }

    private static int charToInt(char c) {
        int x = c - 48;
        if (x < 0 || x > 9) {
            throw new AssertionError((Object)("Unexpected char '" + c + "'"));
        }
        return x;
    }

    static class Counters {
        private static final long MAX_COUNT = 524287L;
        private static final long MAX_DURATION = 0xFFFFFFFFFFFL;
        private static final int MAX_DOCUMENTS_SIZE = 1000;
        final AtomicInteger exceptions = new AtomicInteger(0);
        final AtomicLong requestsAndDurations = new AtomicLong(0L);
        final AtomicInteger unsuccessfulRequests = new AtomicInteger(0);
        final AtomicLong rddsAndDuations = new AtomicLong(0L);
        final AtomicInteger unsuccessfulRdds = new AtomicInteger(0);
        final List<DocumentIngress> documentList = new ArrayList<DocumentIngress>();
        final DerivedMetricProjections derivedMetrics;
        final List<CollectionConfigurationError> configErrors;

        Counters(Map<String, AggregationType> projectionInfo, List<CollectionConfigurationError> errors) {
            this.derivedMetrics = new DerivedMetricProjections(projectionInfo);
            this.configErrors = errors;
        }

        static long encodeCountAndDuration(long count, long duration) {
            if (count > 524287L || duration > 0xFFFFFFFFFFFL) {
                return 0L;
            }
            return (count << 44) + duration;
        }

        static CountAndDuration decodeCountAndDuration(long countAndDuration) {
            return new CountAndDuration(countAndDuration >> 44, countAndDuration & 0xFFFFFFFFFFFL);
        }
    }

    class FinalCounters {
        final int exceptions;
        final int requests;
        final double requestsDuration;
        final int unsuccessfulRequests;
        final long rdds;
        final double rddsDuration;
        final int unsuccessfulRdds;
        final long processPhysicalMemory;
        final double processNormalizedCpuUsage;
        final List<DocumentIngress> documentList = new ArrayList<DocumentIngress>();
        final Map<String, Double> projections;
        final List<CollectionConfigurationError> configErrors;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FinalCounters(Counters currentCounters) {
            this.processPhysicalMemory = this.getPhysicalMemory(memory);
            this.processNormalizedCpuUsage = this.getNormalizedCpuPercentage(QuickPulseDataCollector.this.cpuPerformanceCounterCalculator);
            this.exceptions = currentCounters.exceptions.get();
            CountAndDuration countAndDuration = Counters.decodeCountAndDuration(currentCounters.requestsAndDurations.get());
            this.requests = (int)countAndDuration.count;
            this.requestsDuration = countAndDuration.duration;
            this.unsuccessfulRequests = currentCounters.unsuccessfulRequests.get();
            countAndDuration = Counters.decodeCountAndDuration(currentCounters.rddsAndDuations.get());
            this.rdds = countAndDuration.count;
            this.rddsDuration = countAndDuration.duration;
            this.unsuccessfulRdds = currentCounters.unsuccessfulRdds.get();
            List<DocumentIngress> list = currentCounters.documentList;
            synchronized (list) {
                this.documentList.addAll(currentCounters.documentList);
            }
            this.projections = currentCounters.derivedMetrics.fetchFinalDerivedMetricValues();
            this.configErrors = currentCounters.configErrors;
        }

        private long getPhysicalMemory(@Nullable MemoryMXBean memory) {
            if (memory == null) {
                return -1L;
            }
            MemoryUsage heapMemoryUsage = memory.getHeapMemoryUsage();
            MemoryUsage nonHeapMemoryUsage = memory.getNonHeapMemoryUsage();
            if (heapMemoryUsage == null || nonHeapMemoryUsage == null) {
                return -1L;
            }
            return heapMemoryUsage.getUsed() + nonHeapMemoryUsage.getUsed();
        }

        private double getNormalizedCpuPercentage(@Nullable CpuPerformanceCounterCalculator cpuPerformanceCounterCalculator) {
            if (cpuPerformanceCounterCalculator == null) {
                return -1.0;
            }
            Double cpuDatum = cpuPerformanceCounterCalculator.getCpuPercentage();
            if (cpuDatum == null) {
                return -1.0;
            }
            cpuDatum = cpuDatum / (double)operatingSystemMxBean.getAvailableProcessors();
            return cpuDatum;
        }
    }

    static class CountAndDuration {
        final long count;
        final long duration;

        private CountAndDuration(long count, long duration) {
            this.count = count;
            this.duration = duration;
        }
    }
}

