/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationError;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationErrorType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import java.util.ArrayList;
import java.util.List;

public class ConfigErrorTracker {
    private final List<CollectionConfigurationError> errors = new ArrayList<CollectionConfigurationError>();
    private static final ClientLogger LOGGER = new ClientLogger(ConfigErrorTracker.class);

    public void addError(String message, String eTag, String id, boolean isDerivedMetricId) {
        CollectionConfigurationError error = new CollectionConfigurationError();
        error.setMessage(message);
        error.setCollectionConfigurationErrorType(this.setErrorType(message));
        KeyValuePairString keyValuePair1 = new KeyValuePairString();
        keyValuePair1.setKey("ETag");
        keyValuePair1.setValue(eTag);
        KeyValuePairString keyValuePair2 = new KeyValuePairString();
        keyValuePair2.setKey(isDerivedMetricId ? "DerivedMetricInfoId" : "DocumentStreamInfoId");
        keyValuePair2.setValue(id);
        ArrayList<KeyValuePairString> data = new ArrayList<KeyValuePairString>();
        data.add(keyValuePair1);
        data.add(keyValuePair2);
        error.setData(data);
        this.errors.add(error);
        LOGGER.verbose("{}. Due to this misconfiguration the {} rule with id {} will be ignored by the SDK.", new Object[]{message, isDerivedMetricId ? "derived metric" : "document filter conjunction", id});
    }

    private CollectionConfigurationErrorType setErrorType(String message) {
        if (message.contains("telemetry type")) {
            return CollectionConfigurationErrorType.METRIC_TELEMETRY_TYPE_UNSUPPORTED;
        }
        if (message.contains("duplicate metric id")) {
            return CollectionConfigurationErrorType.METRIC_DUPLICATE_IDS;
        }
        return CollectionConfigurationErrorType.FILTER_FAILURE_TO_CREATE_UNEXPECTED;
    }

    public List<CollectionConfigurationError> getErrors() {
        return new ArrayList<CollectionConfigurationError>(this.errors);
    }
}

