/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.Filter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import java.util.HashMap;
import java.util.Map;

public class CustomDimensions {
    private final Map<String, String> customDimensions;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDimensions.class);

    public CustomDimensions(Map<String, String> customDimensions, Map<String, Double> customMeasurements) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (customDimensions != null) {
            resultMap.putAll(customDimensions);
        }
        if (customMeasurements != null) {
            for (Map.Entry<String, Double> cmEntry : customMeasurements.entrySet()) {
                resultMap.put(cmEntry.getKey(), cmEntry.getValue().toString());
            }
        }
        this.customDimensions = resultMap;
    }

    public boolean matchesAnyFieldInCustomDimensions(FilterInfo filter) {
        for (String value : this.customDimensions.values()) {
            if (!Filter.stringCompare(value, filter.getComparand(), filter.getPredicate())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCustomDimFilter(FilterInfo filter, String trimmedFieldName) {
        if (this.customDimensions.containsKey(trimmedFieldName)) {
            String value = this.customDimensions.get(trimmedFieldName);
            return Filter.stringCompare(value, filter.getComparand(), filter.getPredicate());
        }
        return false;
    }

    public double getCustomDimValueForProjection(String key) {
        if (this.customDimensions.containsKey(key)) {
            String value = this.customDimensions.get(key);
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LOGGER.verbose("The value \"{}\" for the custom dimension \"{}\" could not be converted to a numeric value for a derived metric projection", new Object[]{value, key});
                return Double.NaN;
            }
        }
        LOGGER.verbose("The custom dimension could not be found in this telemetry item when calculating a derived metric.");
        return Double.NaN;
    }
}

