/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.AggregationType;

public class DerivedMetricAggregation {
    private double aggregation;
    private long count = 0L;
    final AggregationType aggregationType;
    private final Object lock = new Object();

    DerivedMetricAggregation(double initValue, AggregationType type) {
        this.aggregation = initValue;
        this.aggregationType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(double incrementBy) {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
            if (this.aggregationType.equals((Object)AggregationType.SUM) || this.aggregationType.equals((Object)AggregationType.AVG)) {
                this.aggregation += incrementBy;
            } else if (this.aggregationType.equals((Object)AggregationType.MIN)) {
                this.aggregation = Math.min(this.aggregation, incrementBy);
            } else if (this.aggregationType.equals((Object)AggregationType.MAX)) {
                this.aggregation = Math.max(this.aggregation, incrementBy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getFinalValue() {
        Object object = this.lock;
        synchronized (object) {
            if (this.count == 0L) {
                return 0.0;
            }
            if (this.aggregationType.equals((Object)AggregationType.AVG)) {
                return this.aggregation / (double)this.count;
            }
            return this.aggregation;
        }
    }
}

