/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.DerivedMetricAggregation;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.AggregationType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DerivedMetricInfo;
import java.util.HashMap;
import java.util.Map;

public class DerivedMetricProjections {
    public static final String COUNT = "Count()";
    private final Map<String, DerivedMetricAggregation> derivedMetricValues = new HashMap<String, DerivedMetricAggregation>();
    private static final ClientLogger LOGGER = new ClientLogger(DerivedMetricProjections.class);

    public DerivedMetricProjections(Map<String, AggregationType> projectionInfo) {
        for (Map.Entry<String, AggregationType> entry : projectionInfo.entrySet()) {
            AggregationType aggregationType = entry.getValue();
            DerivedMetricAggregation value = aggregationType.equals((Object)AggregationType.MIN) ? new DerivedMetricAggregation(Double.MAX_VALUE, aggregationType) : (aggregationType.equals((Object)AggregationType.MAX) ? new DerivedMetricAggregation(Double.MIN_VALUE, aggregationType) : (aggregationType.equals((Object)AggregationType.SUM) || aggregationType.equals((Object)AggregationType.AVG) ? new DerivedMetricAggregation(0.0, aggregationType) : null));
            this.derivedMetricValues.put(entry.getKey(), value);
        }
    }

    public Map<String, Double> fetchFinalDerivedMetricValues() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry<String, DerivedMetricAggregation> entry : this.derivedMetricValues.entrySet()) {
            String id = entry.getKey();
            DerivedMetricAggregation dma = entry.getValue();
            result.put(id, dma.getFinalValue());
        }
        return result;
    }

    public void calculateProjection(DerivedMetricInfo derivedMetricInfo, TelemetryColumns columns) {
        double incrementBy = Double.NaN;
        if (COUNT.equals(derivedMetricInfo.getProjection())) {
            incrementBy = 1.0;
        } else if ("Duration".equals(derivedMetricInfo.getProjection())) {
            long duration = columns.getFieldValue("Duration", Long.class);
            incrementBy = duration == -1L ? Double.NaN : (double)duration / 1000.0;
        } else if (derivedMetricInfo.getProjection().startsWith("CustomDimensions.")) {
            String customDimKey = derivedMetricInfo.getProjection().substring("CustomDimensions.".length());
            incrementBy = columns.getCustomDimValueForProjection(customDimKey);
        }
        if (Double.isNaN(incrementBy)) {
            LOGGER.verbose("This telemetry item will not be counted in derived metric projections because the Duration or a CustomDimension column could not be interpreted as a numeric value.");
        } else {
            this.calculateAggregation(derivedMetricInfo.getId(), incrementBy);
        }
    }

    private void calculateAggregation(String id, double incrementBy) {
        DerivedMetricAggregation dma = this.derivedMetricValues.get(id);
        dma.update(incrementBy);
    }
}

