/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryExceptionData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.TelemetryExceptionDetails;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.CustomDimensions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionDataColumns
implements TelemetryColumns {
    private final CustomDimensions customDims;
    private final Map<String, Object> mapping = new HashMap<String, Object>();

    public ExceptionDataColumns(TelemetryExceptionData exceptionData) {
        this.customDims = new CustomDimensions(exceptionData.getProperties(), exceptionData.getMeasurements());
        List<TelemetryExceptionDetails> details = exceptionData.getExceptions();
        this.mapping.put("Exception.Message", details != null && !details.isEmpty() ? details.get(0).getMessage() : "");
        this.mapping.put("Exception.StackTrace", details != null && !details.isEmpty() ? details.get(0).getStack() : "");
    }

    public ExceptionDataColumns(String message, String stackTrace, Map<String, String> dims, Map<String, Double> measurements) {
        this.customDims = new CustomDimensions(dims, measurements);
        this.mapping.put("Exception.Message", message);
        this.mapping.put("Exception.StackTrace", stackTrace);
    }

    @Override
    public boolean checkAllCustomDims(FilterInfo filter, TelemetryColumns data) {
        return this.customDims.matchesAnyFieldInCustomDimensions(filter);
    }

    @Override
    public boolean checkCustomDimFilter(FilterInfo filter, TelemetryColumns data, String trimmedFieldName) {
        return this.customDims.matchesCustomDimFilter(filter, trimmedFieldName);
    }

    @Override
    public <T> T getFieldValue(String fieldName, Class<T> type) {
        return type.cast(this.mapping.get(fieldName));
    }

    @Override
    public List<String> getAllFieldValuesAsString() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : this.mapping.values()) {
            result.add((String)value);
        }
        return result;
    }

    @Override
    public double getCustomDimValueForProjection(String key) {
        return this.customDims.getCustomDimValueForProjection(key);
    }
}

