/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.models.RequestData;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.CustomDimensions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.filtering.TelemetryColumns;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.FormattedDuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestDataColumns
implements TelemetryColumns {
    private final Map<String, Object> mapping = new HashMap<String, Object>();
    private final CustomDimensions customDims;
    private static final ClientLogger LOGGER = new ClientLogger(RequestDataColumns.class);

    public RequestDataColumns(RequestData requestData) {
        int responseCode;
        this.customDims = new CustomDimensions(requestData.getProperties(), requestData.getMeasurements());
        this.mapping.put("Url", requestData.getUrl());
        this.mapping.put("Success", requestData.isSuccess());
        long durationMicroSec = FormattedDuration.getDurationFromTelemetryItemDurationString(requestData.getDuration());
        if (durationMicroSec == -1L) {
            LOGGER.verbose("The provided timestamp {} could not be converted to microseconds", new Object[]{requestData.getDuration()});
        }
        this.mapping.put("Duration", durationMicroSec);
        this.mapping.put("Name", requestData.getName());
        try {
            responseCode = Integer.parseInt(requestData.getResponseCode());
        }
        catch (NumberFormatException e) {
            responseCode = -1;
            LOGGER.verbose("The provided response code {} could not be converted to a numeric value", new Object[]{requestData.getResponseCode()});
        }
        this.mapping.put("ResponseCode", responseCode);
    }

    public RequestDataColumns(String url, long duration, int responseCode, boolean success, String name, Map<String, String> dims, Map<String, Double> measurements) {
        this.customDims = new CustomDimensions(dims, measurements);
        this.mapping.put("Url", url);
        this.mapping.put("Success", success);
        this.mapping.put("Duration", duration);
        this.mapping.put("Name", name);
        this.mapping.put("ResponseCode", responseCode);
    }

    @Override
    public <T> T getFieldValue(String fieldName, Class<T> type) {
        return type.cast(this.mapping.get(fieldName));
    }

    @Override
    public List<String> getAllFieldValuesAsString() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : this.mapping.values()) {
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            if (value instanceof Integer) {
                result.add(((Integer)value).toString());
                continue;
            }
            if (value instanceof Long) {
                result.add(((Long)value).toString());
                continue;
            }
            result.add(((Boolean)value).toString());
        }
        return result;
    }

    @Override
    public boolean checkAllCustomDims(FilterInfo filter, TelemetryColumns data) {
        return this.customDims.matchesAnyFieldInCustomDimensions(filter);
    }

    @Override
    public boolean checkCustomDimFilter(FilterInfo filter, TelemetryColumns data, String trimmedFieldName) {
        return this.customDims.matchesCustomDimFilter(filter, trimmedFieldName);
    }

    @Override
    public double getCustomDimValueForProjection(String key) {
        return this.customDims.getCustomDimValueForProjection(key);
    }
}

