/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.CollectionConfigurationInfo;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.IsSubscribedHeaders;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.MonitoringDataPoint;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.PublishHeaders;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.ServiceErrorException;
import java.util.List;
import reactor.core.publisher.Mono;

public final class LiveMetricsRestAPIsForClientSDKs {
    private final LiveMetricsRestAPIsForClientSDKsService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    LiveMetricsRestAPIsForClientSDKs(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    LiveMetricsRestAPIsForClientSDKs(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    LiveMetricsRestAPIsForClientSDKs(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (LiveMetricsRestAPIsForClientSDKsService)RestProxy.create(LiveMetricsRestAPIsForClientSDKsService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<IsSubscribedHeaders, CollectionConfigurationInfo>> isSubscribedWithResponseAsync(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint) {
        return FluxUtil.withContext(context -> this.isSubscribedWithResponseAsync(endpoint, ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<IsSubscribedHeaders, CollectionConfigurationInfo>> isSubscribedWithResponseAsync(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint, Context context) {
        String accept = "application/json";
        return this.service.isSubscribed(endpoint, this.getApiVersion(), ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CollectionConfigurationInfo> isSubscribedAsync(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint) {
        return this.isSubscribedWithResponseAsync(endpoint, ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint).flatMap(res -> Mono.justOrEmpty((Object)((CollectionConfigurationInfo)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CollectionConfigurationInfo> isSubscribedAsync(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint, Context context) {
        return this.isSubscribedWithResponseAsync(endpoint, ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, context).flatMap(res -> Mono.justOrEmpty((Object)((CollectionConfigurationInfo)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CollectionConfigurationInfo>> isSubscribedNoCustomHeadersWithResponseAsync(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint) {
        return FluxUtil.withContext(context -> this.isSubscribedNoCustomHeadersWithResponseAsync(endpoint, ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CollectionConfigurationInfo>> isSubscribedNoCustomHeadersWithResponseAsync(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint, Context context) {
        String accept = "application/json";
        return this.service.isSubscribedNoCustomHeaders(endpoint, this.getApiVersion(), ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<IsSubscribedHeaders, CollectionConfigurationInfo> isSubscribedWithResponse(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint, Context context) {
        String accept = "application/json";
        return this.service.isSubscribedSync(endpoint, this.getApiVersion(), ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CollectionConfigurationInfo isSubscribed(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint) {
        return (CollectionConfigurationInfo)this.isSubscribedWithResponse(endpoint, ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CollectionConfigurationInfo> isSubscribedNoCustomHeadersWithResponse(String endpoint, String ikey, Long transmissionTime, String machineName, String instanceName, String streamId, String roleName, String invariantVersion, String configurationEtag, MonitoringDataPoint monitoringDataPoint, Context context) {
        String accept = "application/json";
        return this.service.isSubscribedNoCustomHeadersSync(endpoint, this.getApiVersion(), ikey, transmissionTime, machineName, instanceName, streamId, roleName, invariantVersion, configurationEtag, monitoringDataPoint, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PublishHeaders, CollectionConfigurationInfo>> publishWithResponseAsync(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints) {
        return FluxUtil.withContext(context -> this.publishWithResponseAsync(endpoint, ikey, configurationEtag, transmissionTime, monitoringDataPoints, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PublishHeaders, CollectionConfigurationInfo>> publishWithResponseAsync(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints, Context context) {
        String accept = "application/json";
        return this.service.publish(endpoint, this.getApiVersion(), ikey, configurationEtag, transmissionTime, monitoringDataPoints, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CollectionConfigurationInfo> publishAsync(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints) {
        return this.publishWithResponseAsync(endpoint, ikey, configurationEtag, transmissionTime, monitoringDataPoints).flatMap(res -> Mono.justOrEmpty((Object)((CollectionConfigurationInfo)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CollectionConfigurationInfo> publishAsync(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints, Context context) {
        return this.publishWithResponseAsync(endpoint, ikey, configurationEtag, transmissionTime, monitoringDataPoints, context).flatMap(res -> Mono.justOrEmpty((Object)((CollectionConfigurationInfo)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CollectionConfigurationInfo>> publishNoCustomHeadersWithResponseAsync(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints) {
        return FluxUtil.withContext(context -> this.publishNoCustomHeadersWithResponseAsync(endpoint, ikey, configurationEtag, transmissionTime, monitoringDataPoints, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CollectionConfigurationInfo>> publishNoCustomHeadersWithResponseAsync(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints, Context context) {
        String accept = "application/json";
        return this.service.publishNoCustomHeaders(endpoint, this.getApiVersion(), ikey, configurationEtag, transmissionTime, monitoringDataPoints, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PublishHeaders, CollectionConfigurationInfo> publishWithResponse(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints, Context context) {
        String accept = "application/json";
        return this.service.publishSync(endpoint, this.getApiVersion(), ikey, configurationEtag, transmissionTime, monitoringDataPoints, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CollectionConfigurationInfo publish(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints) {
        return (CollectionConfigurationInfo)this.publishWithResponse(endpoint, ikey, configurationEtag, transmissionTime, monitoringDataPoints, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CollectionConfigurationInfo> publishNoCustomHeadersWithResponse(String endpoint, String ikey, String configurationEtag, Long transmissionTime, List<MonitoringDataPoint> monitoringDataPoints, Context context) {
        String accept = "application/json";
        return this.service.publishNoCustomHeadersSync(endpoint, this.getApiVersion(), ikey, configurationEtag, transmissionTime, monitoringDataPoints, "application/json", context);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="LiveMetricsRestAPIsF")
    public static interface LiveMetricsRestAPIsForClientSDKsService {
        @Post(value="/QuickPulseService.svc/ping")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public Mono<ResponseBase<IsSubscribedHeaders, CollectionConfigurationInfo>> isSubscribed(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-transmission-time") Long var4, @HeaderParam(value="x-ms-qps-machine-name") String var5, @HeaderParam(value="x-ms-qps-instance-name") String var6, @HeaderParam(value="x-ms-qps-stream-id") String var7, @HeaderParam(value="x-ms-qps-role-name") String var8, @HeaderParam(value="x-ms-qps-invariant-version") String var9, @HeaderParam(value="x-ms-qps-configuration-etag") String var10, @BodyParam(value="application/json") MonitoringDataPoint var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/QuickPulseService.svc/ping")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public Mono<Response<CollectionConfigurationInfo>> isSubscribedNoCustomHeaders(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-transmission-time") Long var4, @HeaderParam(value="x-ms-qps-machine-name") String var5, @HeaderParam(value="x-ms-qps-instance-name") String var6, @HeaderParam(value="x-ms-qps-stream-id") String var7, @HeaderParam(value="x-ms-qps-role-name") String var8, @HeaderParam(value="x-ms-qps-invariant-version") String var9, @HeaderParam(value="x-ms-qps-configuration-etag") String var10, @BodyParam(value="application/json") MonitoringDataPoint var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/QuickPulseService.svc/ping")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public ResponseBase<IsSubscribedHeaders, CollectionConfigurationInfo> isSubscribedSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-transmission-time") Long var4, @HeaderParam(value="x-ms-qps-machine-name") String var5, @HeaderParam(value="x-ms-qps-instance-name") String var6, @HeaderParam(value="x-ms-qps-stream-id") String var7, @HeaderParam(value="x-ms-qps-role-name") String var8, @HeaderParam(value="x-ms-qps-invariant-version") String var9, @HeaderParam(value="x-ms-qps-configuration-etag") String var10, @BodyParam(value="application/json") MonitoringDataPoint var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/QuickPulseService.svc/ping")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public Response<CollectionConfigurationInfo> isSubscribedNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-transmission-time") Long var4, @HeaderParam(value="x-ms-qps-machine-name") String var5, @HeaderParam(value="x-ms-qps-instance-name") String var6, @HeaderParam(value="x-ms-qps-stream-id") String var7, @HeaderParam(value="x-ms-qps-role-name") String var8, @HeaderParam(value="x-ms-qps-invariant-version") String var9, @HeaderParam(value="x-ms-qps-configuration-etag") String var10, @BodyParam(value="application/json") MonitoringDataPoint var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/QuickPulseService.svc/post")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public Mono<ResponseBase<PublishHeaders, CollectionConfigurationInfo>> publish(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-configuration-etag") String var4, @HeaderParam(value="x-ms-qps-transmission-time") Long var5, @BodyParam(value="application/json") List<MonitoringDataPoint> var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/QuickPulseService.svc/post")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public Mono<Response<CollectionConfigurationInfo>> publishNoCustomHeaders(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-configuration-etag") String var4, @HeaderParam(value="x-ms-qps-transmission-time") Long var5, @BodyParam(value="application/json") List<MonitoringDataPoint> var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/QuickPulseService.svc/post")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public ResponseBase<PublishHeaders, CollectionConfigurationInfo> publishSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-configuration-etag") String var4, @HeaderParam(value="x-ms-qps-transmission-time") Long var5, @BodyParam(value="application/json") List<MonitoringDataPoint> var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/QuickPulseService.svc/post")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorException.class)
        public Response<CollectionConfigurationInfo> publishNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="ikey") String var3, @HeaderParam(value="x-ms-qps-configuration-etag") String var4, @HeaderParam(value="x-ms-qps-transmission-time") Long var5, @BodyParam(value="application/json") List<MonitoringDataPoint> var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

