/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.AggregationType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.FilterConjunctionGroupInfo;
import java.io.IOException;
import java.util.List;

public final class DerivedMetricInfo
implements JsonSerializable<DerivedMetricInfo> {
    private String id;
    private String telemetryType;
    private List<FilterConjunctionGroupInfo> filterGroups;
    private String projection;
    private AggregationType aggregation;
    private AggregationType backEndAggregation;

    public String getId() {
        return this.id;
    }

    public DerivedMetricInfo setId(String id) {
        this.id = id;
        return this;
    }

    public String getTelemetryType() {
        return this.telemetryType;
    }

    public DerivedMetricInfo setTelemetryType(String telemetryType) {
        this.telemetryType = telemetryType;
        return this;
    }

    public List<FilterConjunctionGroupInfo> getFilterGroups() {
        return this.filterGroups;
    }

    public DerivedMetricInfo setFilterGroups(List<FilterConjunctionGroupInfo> filterGroups) {
        this.filterGroups = filterGroups;
        return this;
    }

    public String getProjection() {
        return this.projection;
    }

    public DerivedMetricInfo setProjection(String projection) {
        this.projection = projection;
        return this;
    }

    public AggregationType getAggregation() {
        return this.aggregation;
    }

    public DerivedMetricInfo setAggregation(AggregationType aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public AggregationType getBackEndAggregation() {
        return this.backEndAggregation;
    }

    public DerivedMetricInfo setBackEndAggregation(AggregationType backEndAggregation) {
        this.backEndAggregation = backEndAggregation;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("Id", this.id);
        jsonWriter.writeStringField("TelemetryType", this.telemetryType);
        jsonWriter.writeArrayField("FilterGroups", this.filterGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("Projection", this.projection);
        jsonWriter.writeStringField("Aggregation", this.aggregation == null ? null : this.aggregation.toString());
        jsonWriter.writeStringField("BackEndAggregation", this.backEndAggregation == null ? null : this.backEndAggregation.toString());
        return jsonWriter.writeEndObject();
    }

    public static DerivedMetricInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DerivedMetricInfo)jsonReader.readObject(reader -> {
            DerivedMetricInfo deserializedDerivedMetricInfo = new DerivedMetricInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Id".equals(fieldName)) {
                    deserializedDerivedMetricInfo.id = reader.getString();
                    continue;
                }
                if ("TelemetryType".equals(fieldName)) {
                    deserializedDerivedMetricInfo.telemetryType = reader.getString();
                    continue;
                }
                if ("FilterGroups".equals(fieldName)) {
                    List filterGroups;
                    deserializedDerivedMetricInfo.filterGroups = filterGroups = reader.readArray(reader1 -> FilterConjunctionGroupInfo.fromJson(reader1));
                    continue;
                }
                if ("Projection".equals(fieldName)) {
                    deserializedDerivedMetricInfo.projection = reader.getString();
                    continue;
                }
                if ("Aggregation".equals(fieldName)) {
                    deserializedDerivedMetricInfo.aggregation = AggregationType.fromString(reader.getString());
                    continue;
                }
                if ("BackEndAggregation".equals(fieldName)) {
                    deserializedDerivedMetricInfo.backEndAggregation = AggregationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDerivedMetricInfo;
        });
    }
}

