/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Event;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Exception;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.RemoteDependency;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Request;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.Trace;
import java.io.IOException;
import java.util.List;

public class DocumentIngress
implements JsonSerializable<DocumentIngress> {
    private DocumentType documentType = DocumentType.fromString("DocumentIngress");
    private List<String> documentStreamIds;
    private List<KeyValuePairString> properties;

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public List<String> getDocumentStreamIds() {
        return this.documentStreamIds;
    }

    public DocumentIngress setDocumentStreamIds(List<String> documentStreamIds) {
        this.documentStreamIds = documentStreamIds;
        return this;
    }

    public List<KeyValuePairString> getProperties() {
        return this.properties;
    }

    public DocumentIngress setProperties(List<KeyValuePairString> properties) {
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("DocumentType", this.documentType == null ? null : this.documentType.toString());
        jsonWriter.writeArrayField("DocumentStreamIds", this.documentStreamIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("Properties", this.properties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentIngress fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentIngress)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DocumentIngress documentIngress;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("DocumentType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Event".equals(discriminatorValue)) {
                    documentIngress = Event.fromJson(readerToUse.reset());
                    return documentIngress;
                }
                if ("Exception".equals(discriminatorValue)) {
                    documentIngress = Exception.fromJson(readerToUse.reset());
                    return documentIngress;
                }
                if ("RemoteDependency".equals(discriminatorValue)) {
                    documentIngress = RemoteDependency.fromJson(readerToUse.reset());
                    return documentIngress;
                }
                if ("Request".equals(discriminatorValue)) {
                    documentIngress = Request.fromJson(readerToUse.reset());
                    return documentIngress;
                }
                if ("Trace".equals(discriminatorValue)) {
                    documentIngress = Trace.fromJson(readerToUse.reset());
                    return documentIngress;
                }
                documentIngress = DocumentIngress.fromJsonKnownDiscriminator(readerToUse.reset());
                return documentIngress;
            }
        });
    }

    static DocumentIngress fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DocumentIngress)jsonReader.readObject(reader -> {
            DocumentIngress deserializedDocumentIngress = new DocumentIngress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DocumentType".equals(fieldName)) {
                    deserializedDocumentIngress.documentType = DocumentType.fromString(reader.getString());
                    continue;
                }
                if ("DocumentStreamIds".equals(fieldName)) {
                    List documentStreamIds;
                    deserializedDocumentIngress.documentStreamIds = documentStreamIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    List properties;
                    deserializedDocumentIngress.properties = properties = reader.readArray(reader1 -> KeyValuePairString.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentIngress;
        });
    }
}

