/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentIngress;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.DocumentType;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.KeyValuePairString;
import java.io.IOException;
import java.util.List;

public final class Event
extends DocumentIngress {
    private DocumentType documentType = DocumentType.EVENT;
    private String name;

    @Override
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getName() {
        return this.name;
    }

    public Event setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Event setDocumentStreamIds(List<String> documentStreamIds) {
        super.setDocumentStreamIds(documentStreamIds);
        return this;
    }

    @Override
    public Event setProperties(List<KeyValuePairString> properties) {
        super.setProperties(properties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("DocumentStreamIds", this.getDocumentStreamIds(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("Properties", this.getProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("DocumentType", this.documentType == null ? null : this.documentType.toString());
        jsonWriter.writeStringField("Name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static Event fromJson(JsonReader jsonReader) throws IOException {
        return (Event)jsonReader.readObject(reader -> {
            Event deserializedEvent = new Event();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DocumentStreamIds".equals(fieldName)) {
                    List documentStreamIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedEvent.setDocumentStreamIds(documentStreamIds);
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    List properties = reader.readArray(reader1 -> KeyValuePairString.fromJson(reader1));
                    deserializedEvent.setProperties(properties);
                    continue;
                }
                if ("DocumentType".equals(fieldName)) {
                    deserializedEvent.documentType = DocumentType.fromString(reader.getString());
                    continue;
                }
                if ("Name".equals(fieldName)) {
                    deserializedEvent.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEvent;
        });
    }
}

