/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.quickpulse.swagger.models.PredicateType;
import java.io.IOException;

public final class FilterInfo
implements JsonSerializable<FilterInfo> {
    private String fieldName;
    private PredicateType predicate;
    private String comparand;

    public String getFieldName() {
        return this.fieldName;
    }

    public FilterInfo setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public PredicateType getPredicate() {
        return this.predicate;
    }

    public FilterInfo setPredicate(PredicateType predicate) {
        this.predicate = predicate;
        return this;
    }

    public String getComparand() {
        return this.comparand;
    }

    public FilterInfo setComparand(String comparand) {
        this.comparand = comparand;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("FieldName", this.fieldName);
        jsonWriter.writeStringField("Predicate", this.predicate == null ? null : this.predicate.toString());
        jsonWriter.writeStringField("Comparand", this.comparand);
        return jsonWriter.writeEndObject();
    }

    public static FilterInfo fromJson(JsonReader jsonReader) throws IOException {
        return (FilterInfo)jsonReader.readObject(reader -> {
            FilterInfo deserializedFilterInfo = new FilterInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("FieldName".equals(jsonFieldName)) {
                    deserializedFilterInfo.fieldName = reader.getString();
                    continue;
                }
                if ("Predicate".equals(jsonFieldName)) {
                    deserializedFilterInfo.predicate = PredicateType.fromString(reader.getString());
                    continue;
                }
                if ("Comparand".equals(jsonFieldName)) {
                    deserializedFilterInfo.comparand = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilterInfo;
        });
    }
}

